/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeBrick;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockDragonforgeBricks
extends BlockContainer
implements IDragonProof {
    public static final PropertyBool GRILL = PropertyBool.func_177716_a((String)"grill");
    private final boolean isFire;

    public BlockDragonforgeBricks(boolean isFire) {
        super(Material.field_151576_e);
        this.func_149713_g(2);
        this.func_149711_c(40.0f);
        this.func_149752_b(500.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(IceAndFire.TAB_BLOCKS);
        this.func_149663_c("iceandfire.dragonforge_" + (isFire ? "fire" : "ice") + "_brick");
        this.setRegistryName("iceandfire", "dragonforge_" + (isFire ? "fire" : "ice") + "_brick");
        this.isFire = isFire;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)GRILL, (Comparable)Boolean.FALSE));
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.getConnectedTileEntity(worldIn, pos) != null) {
            TileEntityDragonforge forge = this.getConnectedTileEntity(worldIn, pos);
            if (forge.isFire == this.isFire) {
                worldIn.func_175684_a(forge.func_174877_v(), (Block)this, this.func_149738_a(worldIn));
                return forge.func_145838_q().func_180639_a(worldIn, forge.func_174877_v(), worldIn.func_180495_p(forge.func_174877_v()), playerIn, hand, facing, hitX, hitY, hitZ);
            }
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkGrill(worldIn, pos);
        }
    }

    public int func_149738_a(World worldIn) {
        return 3;
    }

    private void checkGrill(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        boolean missingFurnace = this.getConnectedTileEntity(worldIn, pos) == null;
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)GRILL, (Comparable)Boolean.valueOf(!missingFurnace)));
    }

    private TileEntityDragonforge getConnectedTileEntity(World worldIn, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntityDragonforge forge;
            if (worldIn.func_175625_s(pos.func_177972_a(facing)) == null || !(worldIn.func_175625_s(pos.func_177972_a(facing)) instanceof TileEntityDragonforge) || (forge = (TileEntityDragonforge)worldIn.func_175625_s(pos.func_177972_a(facing))) == null || !forge.assembled()) continue;
            return forge;
        }
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)GRILL, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)GRILL) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GRILL});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDragonforgeBrick();
    }
}

