/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.api;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class FoodUtils {
    public static int getFoodPoints(Entity entity) {
        int foodPoints = Math.round(entity.field_70130_N * entity.field_70131_O * 10.0f);
        if (entity instanceof EntityAgeable) {
            return foodPoints;
        }
        if (entity instanceof EntityPlayer) {
            return 15;
        }
        return 0;
    }

    public static int getFoodPoints(ItemStack item, boolean meatOnly, boolean includeFish) {
        if (item != null && item != ItemStack.field_190927_a && item.func_77973_b() instanceof ItemFood) {
            int food = ((ItemFood)item.func_77973_b()).func_150905_g(item) * 10;
            if (!meatOnly) {
                return food;
            }
            if (((ItemFood)item.func_77973_b()).func_77845_h()) {
                return food;
            }
            if (includeFish && item.func_77973_b() == Items.field_151115_aP) {
                return food;
            }
        }
        return 0;
    }

    public static boolean isSeeds(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemSeeds && item != Items.field_151075_bm) {
            return true;
        }
        NonNullList listAllseed = OreDictionary.getOres((String)"listAllseed");
        NonNullList listAllSeeds = OreDictionary.getOres((String)"listAllSeeds");
        NonNullList seed = OreDictionary.getOres((String)"seed");
        NonNullList seeds = OreDictionary.getOres((String)"seeds");
        return listAllseed.contains((Object)stack) || listAllSeeds.contains((Object)stack) || seed.contains((Object)stack) || seeds.contains((Object)stack);
    }
}

