/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.api.FoodCapability;
import com.cazsius.solcarrot.api.SOLCarrotAPI;
import com.cazsius.solcarrot.tracking.FoodInstance;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

@ParametersAreNonnullByDefault
public final class FoodList
implements FoodCapability {
    private static final String NBT_KEY_FOOD_LIST = "foodList";
    private static final String NBT_KEY_PROGRESS_INFO = "progressInfo";
    private final Set<FoodInstance> foods = new HashSet<FoodInstance>();
    private ProgressInfo progressInfo = new ProgressInfo(this);

    public static FoodList get(EntityPlayer player) {
        FoodList foodList = (FoodList)player.getCapability(SOLCarrotAPI.foodCapability, null);
        assert (foodList != null);
        return foodList;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == SOLCarrotAPI.foodCapability;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == SOLCarrotAPI.foodCapability ? this : null);
    }

    public NBTBase serializeNBT() {
        NBTTagList list = new NBTTagList();
        this.foods.stream().map(FoodInstance::encode).filter(Objects::nonNull).map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)list).func_74742_a(arg_0));
        return list;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagList list = (NBTTagList)nbt;
        this.foods.clear();
        StreamSupport.stream(list.spliterator(), false).map(tag -> (NBTTagString)tag).map(NBTTagString::func_150285_a_).map(FoodInstance::decode).filter(Objects::nonNull).forEach(this.foods::add);
        this.updateProgressInfo();
    }

    public NBTTagCompound serializeFullNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_KEY_FOOD_LIST, this.serializeNBT());
        tag.func_74782_a(NBT_KEY_PROGRESS_INFO, (NBTBase)this.progressInfo.getNBT());
        return tag;
    }

    public void deserializeFullNBT(NBTTagCompound tag) {
        this.deserializeNBT(tag.func_74781_a(NBT_KEY_FOOD_LIST));
        this.progressInfo = new ProgressInfo(tag.func_74775_l(NBT_KEY_PROGRESS_INFO));
    }

    public boolean addFood(ItemStack food) {
        boolean wasAdded = this.foods.add(new FoodInstance(food)) && this.getConfigInfo().shouldCount(food);
        this.updateProgressInfo();
        return wasAdded;
    }

    @Override
    public boolean hasEaten(ItemStack itemStack) {
        return this.foods.contains(new FoodInstance(itemStack));
    }

    public void clearFood() {
        this.foods.clear();
        this.updateProgressInfo();
    }

    public Set<FoodInstance> getEatenFoods() {
        return new HashSet<FoodInstance>(this.foods);
    }

    public ProgressInfo getProgressInfo() {
        return this.progressInfo;
    }

    public ProgressInfo.ConfigInfo getConfigInfo() {
        return this.progressInfo.configInfo;
    }

    public void updateProgressInfo() {
        this.progressInfo = new ProgressInfo(this);
    }

    @Override
    public int getEatenFoodCount() {
        return this.foods.size();
    }

    public static final class Storage
    implements Capability.IStorage<FoodCapability> {
        public NBTBase writeNBT(Capability<FoodCapability> capability, FoodCapability instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<FoodCapability> capability, FoodCapability instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT(nbt);
        }
    }
}

