/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.enderio.core.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class NullHelper {
    private NullHelper() {
    }

    @Nonnull
    public static final <P> P notnull(@Nullable P o, @Nonnull String message) {
        return NullHelper.notnull(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P notnullJ(@Nullable P o, @Nonnull String message) {
        return NullHelper.notnullJ(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P notnullM(@Nullable P o, @Nonnull String message) {
        return NullHelper.notnullM(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P notnullF(@Nullable P o, @Nonnull String message) {
        return NullHelper.notnullF(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P untrusted(@Nonnull P o, @Nonnull String message) {
        return NullHelper.untrusted(o, new Object[]{message});
    }

    @Nonnull
    public static final <P> P notnull(@Nullable P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("Houston we have a problem: '" + NullHelper.join(message) + "'. Please report that on our bugtracker unless you are using some old version. Thank you.");
        }
        return o;
    }

    @Nonnull
    public static final <P> P notnullJ(@Nullable P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("There was a problem with Java: The call '" + NullHelper.join(message) + "' returned null even though it should not be able to do that. Is your Java broken?");
        }
        return o;
    }

    @Nonnull
    public static final <P> P notnullM(@Nullable P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("There was a problem with Minecraft: The call '" + NullHelper.join(message) + "' returned null even though it should not be able to do that. Is your Minecraft broken? Did some other mod break it?");
        }
        return o;
    }

    @Nonnull
    public static final <P> P notnullF(@Nullable P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("There was a problem with Forge: The call '" + NullHelper.join(message) + "' returned null even though it should not be able to do that. Is your Forge broken? Did some other mod break it?");
        }
        return o;
    }

    @Nonnull
    public static final <P> P untrusted(@Nonnull P o, Object ... message) {
        if (o == null) {
            throw new NullPointerException("There was a problem with Minecraft: The call '" + NullHelper.join(message) + "' returned null even though it says it is not be able to do that. Your Minecraft is broken. This mod is NOT(!) the cause of this crash!");
        }
        return o;
    }

    @Nullable
    public static final <P> P untrust(@Nonnull P o) {
        return o;
    }

    @SafeVarargs
    @Nonnull
    public static final <P> P first(P ... o) {
        for (P on : NullHelper.notnull(o, new Object[]{"... param is null"})) {
            if (on == null) continue;
            return on;
        }
        throw new NullPointerException("Houston we have a problem. Please report that on our bugtracker unless you are using some old version. Thank you.");
    }

    private static String join(Object ... data) {
        StringBuilder b = new StringBuilder();
        for (Object object : data) {
            b.append(object);
        }
        return b.toString();
    }
}

