/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.enderio.core.client.render;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IconUtil {
    @Nonnull
    public static IconUtil instance = new IconUtil();
    @Nonnull
    private final ArrayList<IIconProvider> iconProviders = new ArrayList();
    @Nonnull
    public TextureAtlasSprite whiteTexture;
    @Nonnull
    public TextureAtlasSprite blankTexture;
    @Nonnull
    public TextureAtlasSprite errorTexture;
    private boolean doneInit = false;

    public static void addIconProvider(@Nonnull IIconProvider registrar) {
        IconUtil.instance.iconProviders.add(registrar);
    }

    private IconUtil() {
    }

    public void init() {
        if (this.doneInit) {
            return;
        }
        this.doneInit = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
        IconUtil.addIconProvider(new IIconProvider(){

            @Override
            public void registerIcons(@Nonnull TextureMap register) {
                IconUtil.this.whiteTexture = register.func_174942_a(new ResourceLocation("arcanearchives", "white"));
                IconUtil.this.errorTexture = register.func_174942_a(new ResourceLocation("arcanearchives", "error"));
                IconUtil.this.blankTexture = register.func_174942_a(new ResourceLocation("arcanearchives", "blank"));
            }
        });
    }

    @SubscribeEvent
    public void onIconLoad(TextureStitchEvent.Pre event) {
        for (IIconProvider reg : this.iconProviders) {
            TextureMap map = event.getMap();
            if (map == null) continue;
            reg.registerIcons(map);
        }
    }

    @Nonnull
    public static TextureAtlasSprite getIconForItem(@Nonnull Item item, int meta) {
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178087_a(item, meta);
        return icon != null ? icon : Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public static interface IIconProvider {
        public void registerIcons(@Nonnull TextureMap var1);
    }
}

