/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.util;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;

public class WorldUtil {
    @Nullable
    public static <T> T getTileEntity(Class<T> clazz, int dimension, BlockPos pos) {
        return WorldUtil.getTileEntity(clazz, dimension, pos, false);
    }

    @Nullable
    public static <T> T getTileEntity(Class<T> clazz, int dimension, BlockPos pos, boolean forceChunkLoad) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return null;
        }
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            return null;
        }
        return WorldUtil.getTileEntity(clazz, (IBlockAccess)world, pos, forceChunkLoad);
    }

    @Nullable
    public static <T> T getTileEntity(Class<T> clazz, IBlockAccess world, BlockPos pos, boolean forceChunkLoad) {
        if (world == null || pos == null) {
            return null;
        }
        if (world instanceof World && !((World)world).func_175667_e(pos) && !forceChunkLoad) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        if (clazz.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    @Nullable
    public static <T> T getTileEntity(Class<T> clazz, IBlockAccess world, BlockPos pos) {
        return WorldUtil.getTileEntity(clazz, world, pos, false);
    }

    public static boolean isChunkLoaded(World world, BlockPos pos) {
        return world.func_175667_e(pos);
    }

    public static void spawnInventoryInWorld(World world, double x, double y, double z, IItemHandler inventory) {
        WorldUtil.spawnInventoryInWorld(world, new BlockPos(x, y, z), inventory);
    }

    public static void spawnInventoryInWorld(World world, BlockPos pos, IItemHandler inventory) {
        if (inventory != null && !world.field_72995_K) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i).func_190926_b()) continue;
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)inventory.getStackInSlot(i));
            }
        }
    }
}

