/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RayTracingUtils {
    public static RayTraceResult raytraceClosestObject(World world, @Nullable Entity exclude, Vec3d startVec, Vec3d endVec) {
        RayTraceResult result = world.func_72933_a(startVec, endVec);
        double blockHitDistance = 0.0;
        if (result != null) {
            blockHitDistance = result.field_72307_f.func_72438_d(startVec);
        }
        AxisAlignedBB entitySearchArea = new AxisAlignedBB(startVec.field_72450_a, startVec.field_72448_b, startVec.field_72449_c, endVec.field_72450_a, endVec.field_72448_b, endVec.field_72449_c);
        Entity hitEntity = null;
        double entityHitDistance = 0.0;
        for (Entity entity : world.func_175674_a(exclude, entitySearchArea, EntitySelectors.field_180132_d)) {
            double distance;
            AxisAlignedBB collisionBB = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult intercept = collisionBB.func_72327_a(startVec, endVec);
            if (intercept == null || !((distance = startVec.func_72438_d(intercept.field_72307_f)) < blockHitDistance) && blockHitDistance != 0.0 || !(distance < entityHitDistance) && entityHitDistance != 0.0) continue;
            entityHitDistance = distance;
            hitEntity = entity;
        }
        if (hitEntity != null) {
            result = new RayTraceResult(hitEntity, hitEntity.func_174791_d());
        }
        return result;
    }

    public static void raytraceAll(List<RayTraceResult> results, World world, @Nullable Entity exclude, Vec3d startVec, Vec3d endVec) {
        RayTraceResult blockRaytrace = world.func_72933_a(startVec, endVec);
        if (blockRaytrace != null) {
            results.add(blockRaytrace);
        }
        AxisAlignedBB entitySearchArea = new AxisAlignedBB(startVec.field_72450_a, startVec.field_72448_b, startVec.field_72449_c, endVec.field_72450_a, endVec.field_72448_b, endVec.field_72449_c);
        for (Entity entity : world.func_175674_a(exclude, entitySearchArea, EntitySelectors.field_180132_d)) {
            AxisAlignedBB collisionBB = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult intercept = collisionBB.func_72327_a(startVec, endVec);
            if (intercept == null) continue;
            results.add(new RayTraceResult(entity, intercept.field_72307_f));
        }
    }
}

