/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.util;

import java.text.DecimalFormat;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class MathUtils {
    private static final int NUM_X_BITS;
    private static final int NUM_Z_BITS;
    private static final int NUM_Y_BITS;
    private static final int Y_SHIFT;
    private static final int X_SHIFT;
    private static final long X_MASK;
    private static final long Y_MASK;
    private static final long Z_MASK;

    public static int intDivisionFloor(int a, int b) {
        return a / b;
    }

    public static int intDivisionCeiling(int a, int b) {
        return (a + (b - 1)) / b;
    }

    public static String format(long v) {
        char[] suffix = new char[]{' ', 'k', 'M', 'B', 'T', 'P', 'E'};
        int value = (int)Math.floor(Math.log10(v));
        int base = value / 3;
        if (value >= 3 && base < suffix.length) {
            return new DecimalFormat("~#0.0").format((double)v / Math.pow(10.0, base * 3)) + suffix[base];
        }
        return new DecimalFormat("#,##0").format(v);
    }

    public static Vec3d vec3dFromLong(long serialized) {
        int i = (int)(serialized << 64 - X_SHIFT - NUM_X_BITS >> 64 - NUM_X_BITS);
        int j = (int)(serialized << 64 - Y_SHIFT - NUM_Y_BITS >> 64 - NUM_Y_BITS);
        int k = (int)(serialized << 64 - NUM_Z_BITS >> 64 - NUM_Z_BITS);
        return new Vec3d((double)i, (double)j, (double)k);
    }

    public static long vec3dToLong(Vec3d pos) {
        return ((long)pos.field_72450_a & X_MASK) << X_SHIFT | ((long)pos.field_72448_b & Y_MASK) << Y_SHIFT | (long)pos.field_72449_c & Z_MASK;
    }

    static {
        NUM_Z_BITS = NUM_X_BITS = 1 + MathHelper.func_151239_c((int)MathHelper.func_151236_b((int)30000000));
        NUM_Y_BITS = 64 - NUM_X_BITS - NUM_Z_BITS;
        Y_SHIFT = 0 + NUM_Z_BITS;
        X_SHIFT = Y_SHIFT + NUM_Y_BITS;
        X_MASK = (1L << NUM_X_BITS) - 1L;
        Y_MASK = (1L << NUM_Y_BITS) - 1L;
        Z_MASK = (1L << NUM_Z_BITS) - 1L;
    }
}

