/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.util;

import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantTankTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemUtils {
    public static boolean areStacksEqualIgnoreSize(ItemStack stackA, ItemStack stackB) {
        return ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean areStacksEqualIgnoreSizeMaybeEmpty(ItemStack stackA, ItemStack stackB, boolean maybeIgnoreEmpty) {
        if (stackA == stackB) {
            return true;
        }
        if (maybeIgnoreEmpty ? !stackA.func_77969_a(stackB) : stackA.func_190926_b() || stackB.func_190926_b() || !stackA.func_77969_a(stackB)) {
            return false;
        }
        if (maybeIgnoreEmpty) {
            if ((stackA.func_77978_p() == null || stackA.func_77978_p().func_82582_d()) && (stackB.func_77978_p() == null || stackB.func_77978_p().func_82582_d())) {
                return true;
            }
            return stackA.func_77978_p() != null && stackA.func_77978_p().equals((Object)stackB.func_77978_p()) && stackA.areCapsCompatible(stackB);
        }
        return ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static int calculateRedstoneFromTileEntity(@Nullable TileEntity te) {
        if (te instanceof RadiantChestTileEntity) {
            return ItemUtils.calculateRedstoneFromItemHandler((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        if (te instanceof RadiantTroveTileEntity) {
            RadiantTroveTileEntity trove = (RadiantTroveTileEntity)te;
            RadiantTroveTileEntity.TroveItemHandler handler = trove.getInventory();
            float f = (float)handler.getCount() / (float)handler.getMaxCount();
            return MathHelper.func_76141_d((float)(f * 14.0f)) + (handler.getCount() > 0 ? 1 : 0);
        }
        if (te instanceof RadiantTankTileEntity) {
            RadiantTankTileEntity tank = (RadiantTankTileEntity)te;
            int amount = tank.getInventory().getFluidAmount();
            float f = (float)amount / (float)tank.getCapacity();
            return MathHelper.func_76141_d((float)(f * 14.0f)) + (amount > 0 ? 1 : 0);
        }
        return 0;
    }

    public static int calculateRedstoneFromItemHandler(@Nullable IItemHandler handler) {
        if (handler == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack itemstack = handler.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)handler.getSlotLimit(i);
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)handler.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static NBTTagCompound getOrCreateTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public static boolean ingredientsMatch(Ingredient ingredient1, Ingredient ingredient2) {
        if (ingredient1.isSimple() != ingredient2.isSimple()) {
            return false;
        }
        for (ItemStack stack : ingredient2.func_193365_a()) {
            if (ingredient1.apply(stack)) continue;
            return false;
        }
        for (ItemStack stack : ingredient1.func_193365_a()) {
            if (ingredient2.apply(stack)) continue;
            return false;
        }
        return true;
    }
}

