/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.util;

import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColorUtils {
    public static Color COLORSTEP_0 = new Color(1.0f, 0.5f, 0.5f, 1.0f);
    public static Color COLORSTEP_1 = new Color(1.0f, 0.75f, 0.5f, 1.0f);
    public static Color COLORSTEP_2 = new Color(1.0f, 1.0f, 0.5f, 1.0f);
    public static Color COLORSTEP_3 = new Color(0.5f, 1.0f, 0.6f, 1.0f);
    public static Color COLORSTEP_4 = new Color(0.5f, 1.0f, 1.0f, 1.0f);
    public static Color COLORSTEP_5 = new Color(0.5f, 0.65f, 1.0f, 1.0f);
    public static Color COLORSTEP_6 = new Color(0.8f, 0.5f, 1.0f, 1.0f);
    public static Color COLORSTEP_7 = new Color(1.0f, 0.55f, 1.0f, 1.0f);
    private static int colorIncrement = 12;

    public static ColourLight parseColour(int colour, int light) {
        return new ColourLight(colour, light);
    }

    public static Color getColorFromTime(long worldTime) {
        Color second;
        Color first;
        int clippedTime = (int)(worldTime % (long)(colorIncrement * 8));
        int band = clippedTime / colorIncrement;
        float prog = (float)(clippedTime % colorIncrement) / (float)colorIncrement;
        switch (band) {
            case 0: {
                first = COLORSTEP_0;
                second = COLORSTEP_1;
                break;
            }
            case 1: {
                first = COLORSTEP_1;
                second = COLORSTEP_2;
                break;
            }
            case 2: {
                first = COLORSTEP_2;
                second = COLORSTEP_3;
                break;
            }
            case 3: {
                first = COLORSTEP_3;
                second = COLORSTEP_4;
                break;
            }
            case 4: {
                first = COLORSTEP_4;
                second = COLORSTEP_5;
                break;
            }
            case 5: {
                first = COLORSTEP_5;
                second = COLORSTEP_6;
                break;
            }
            case 6: {
                first = COLORSTEP_6;
                second = COLORSTEP_7;
                break;
            }
            case 7: {
                first = COLORSTEP_7;
                second = COLORSTEP_0;
                break;
            }
            default: {
                first = new Color(1.0f, 1.0f, 1.0f, 1.0f);
                second = new Color(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
        Color color = Color.Lerp(first, second, prog);
        return color;
    }

    public static float[] getARGB(int colour) {
        return new float[]{colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF};
    }

    @SideOnly(value=Side.CLIENT)
    public static class Color {
        public float red;
        public float green;
        public float blue;
        public float alpha;

        public Color() {
            this(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public Color(float redIn, float greenIn, float blueIn, float alphaIn) {
            this.red = redIn;
            this.green = greenIn;
            this.blue = blueIn;
            this.alpha = alphaIn;
        }

        public static Color Lerp(Color one, Color two, float prog) {
            Color lerped = new Color();
            lerped.red = (float)MathHelper.func_151238_b((double)one.red, (double)two.red, (double)prog);
            lerped.green = (float)MathHelper.func_151238_b((double)one.green, (double)two.green, (double)prog);
            lerped.blue = (float)MathHelper.func_151238_b((double)one.blue, (double)two.blue, (double)prog);
            lerped.alpha = (float)MathHelper.func_151238_b((double)one.alpha, (double)two.alpha, (double)prog);
            return lerped;
        }

        public static String FormatForLogger(Color c, boolean includeAlpha) {
            String str = "";
            str = str + "<R:" + c.red;
            str = str + "  G:" + c.green;
            str = str + "  B:" + c.blue;
            if (includeAlpha) {
                str = str + "  A:" + c.alpha;
            }
            str = str + ">";
            return str;
        }

        public int toInteger() {
            int result = (int)(this.alpha * 255.0f) << 8;
            result = result + (int)(this.red * 255.0f) << 8;
            result = result + (int)(this.green * 255.0f) << 8;
            return result += (int)(this.blue * 255.0f);
        }
    }

    public static class ColourLight {
        public final int light1;
        public final int light2;
        public final int alpha;
        public final int red;
        public final int green;
        public final int blue;

        public ColourLight(int colour, int light) {
            this.light1 = light >> 16 & 0xFFFF;
            this.light2 = light & 0xFFFF;
            this.alpha = colour >> 24 & 0xFF;
            this.red = colour >> 16 & 0xFF;
            this.green = colour >> 8 & 0xFF;
            this.blue = colour & 0xFF;
        }
    }
}

