/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.types.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class ListConcatIterable<T>
implements Iterable<T> {
    private List<List<T>> lists;
    private Iterator<List<T>> listIterator;
    private List<T> entry = null;
    private Iterator<T> iterator = null;

    public ListConcatIterable(Collection<List<T>> lists) {
        this.lists = lists.stream().filter(t -> !t.isEmpty()).collect(Collectors.toList());
        this.listIterator = this.lists.iterator();
        if (this.listIterator.hasNext()) {
            this.entry = this.listIterator.next();
            this.iterator = this.entry.iterator();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ListConcatIterator();
    }

    private void nextIterator() {
        if (this.listIterator.hasNext()) {
            this.entry = this.listIterator.next();
            this.iterator = this.entry.iterator();
        } else {
            this.entry = null;
            this.iterator = null;
        }
    }

    public class ListConcatIterator
    implements Iterator<T> {
        @Override
        public boolean hasNext() {
            if (ListConcatIterable.this.entry == null) {
                return false;
            }
            if (ListConcatIterable.this.iterator != null && !ListConcatIterable.this.iterator.hasNext()) {
                return ListConcatIterable.this.listIterator.hasNext();
            }
            if (ListConcatIterable.this.iterator != null) {
                return ListConcatIterable.this.iterator.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            if (ListConcatIterable.this.iterator == null || !ListConcatIterable.this.iterator.hasNext()) {
                ListConcatIterable.this.nextIterator();
            }
            if (ListConcatIterable.this.iterator == null || !ListConcatIterable.this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            return ListConcatIterable.this.iterator.next();
        }
    }
}

