/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.tileentities;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.inventory.handlers.ITroveItemHandler;
import com.aranaira.arcanearchives.inventory.handlers.OptionalUpgradesHandler;
import com.aranaira.arcanearchives.inventory.handlers.SizeUpgradeItemHandler;
import com.aranaira.arcanearchives.inventory.handlers.TroveUpgradeItemHandler;
import com.aranaira.arcanearchives.items.templates.IItemScepter;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IBrazierRouting;
import com.aranaira.arcanearchives.tileentities.interfaces.IManifestTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IUpgradeableStorage;
import com.aranaira.arcanearchives.types.enums.UpgradeType;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.PlayerUtil;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.awt.Point;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class RadiantTroveTileEntity
extends ImmanenceTileEntity
implements IManifestTileEntity,
IUpgradeableStorage,
IBrazierRouting {
    public static int BASE_MODIFIER = 512;
    public static int BASE_COUNT = 32768;
    private final TroveItemHandler inventory = new TroveItemHandler(this);
    private long lastClick = 0L;
    private long lastTick = 0L;
    private UUID lastUUID = null;
    public boolean wasCreativeDrop = false;
    private TroveUpgradeItemHandler sizeUpgrades = new TroveUpgradeItemHandler(){

        @Override
        public void onContentsChanged() {
            if (!((RadiantTroveTileEntity)RadiantTroveTileEntity.this).field_145850_b.field_72995_K) {
                RadiantTroveTileEntity.this.func_70296_d();
                RadiantTroveTileEntity.this.defaultServerSideUpdate();
            }
            RadiantTroveTileEntity.this.inventory.setUpgrades(RadiantTroveTileEntity.this.getModifiedCapacity());
        }

        @Override
        public boolean canReduceMultiplierTo(int size) {
            RadiantTroveTileEntity te = RadiantTroveTileEntity.this;
            return te.inventory.getCount() <= te.inventory.getMaxCount(size);
        }
    };
    private OptionalUpgradesHandler optionalUpgrades = new OptionalUpgradesHandler();
    private Int2IntOpenHashMap result = new Int2IntOpenHashMap();

    public long getLastClick() {
        return this.lastClick;
    }

    public long getLastTick() {
        return this.lastTick;
    }

    public UUID getLastUUID() {
        return this.lastUUID;
    }

    public RadiantTroveTileEntity() {
        super("radianttrove");
    }

    public void onRightClickTrove(EntityPlayer player) {
        IItemHandler playerMain;
        ItemStack result;
        ItemStack mainhand = player.func_184614_ca();
        boolean fakeHand = false;
        if (mainhand.func_190926_b()) {
            if (this.inventory.isEmpty()) {
                return;
            }
            mainhand = this.inventory.getItem();
            fakeHand = true;
        }
        this.func_70296_d();
        if (this.inventory.isEmpty()) {
            this.inventory.setReference(mainhand);
        }
        ItemStack reference = this.inventory.getItem();
        UUID playerId = player.func_110124_au();
        boolean doubleClick = false;
        if (this.lastUUID == playerId && System.currentTimeMillis() - this.lastClick <= 800L) {
            doubleClick = true;
        }
        this.lastUUID = playerId;
        this.lastClick = System.currentTimeMillis();
        if (!ItemUtils.areStacksEqualIgnoreSize(reference, mainhand) && !fakeHand) {
            if (!doubleClick) {
                return;
            }
            fakeHand = true;
            mainhand = this.inventory.getItem();
        }
        if (!fakeHand) {
            result = this.inventory.insertItem(0, mainhand, false);
            if (!result.func_190926_b()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.error.trove_insertion_failed.full", new Object[0]), true);
                mainhand.func_190920_e(result.func_190916_E());
                return;
            }
            mainhand.func_190920_e(0);
        }
        if (doubleClick && (playerMain = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null) {
            for (int i = 0; i < playerMain.getSlots(); ++i) {
                ItemStack inSlot = playerMain.getStackInSlot(i);
                if (!ItemUtils.areStacksEqualIgnoreSize(reference, inSlot)) continue;
                result = this.inventory.insertItem(0, inSlot, true);
                if (!result.func_190926_b()) {
                    int diff = inSlot.func_190916_E() - result.func_190916_E();
                    this.inventory.insertItem(0, playerMain.extractItem(i, diff, false), false);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.error.trove_insertion_failed.full", new Object[0]), true);
                    this.func_70296_d();
                    return;
                }
                int thisCount = inSlot.func_190916_E();
                this.inventory.insertItem(0, playerMain.extractItem(i, thisCount, false), false);
            }
        }
        PlayerUtil.Server.syncInventory((EntityPlayerMP)player);
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public void onLeftClickTrove(EntityPlayer player) {
        boolean trovesDispense;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (player.func_70093_af() && player.field_71071_by.func_70448_g().func_77973_b() instanceof IItemScepter) {
            return;
        }
        if (System.currentTimeMillis() - this.lastTick < 150L) {
            return;
        }
        this.lastTick = System.currentTimeMillis();
        this.func_70296_d();
        ItemStack stack = this.inventory.extractItem(0, 1, true);
        if (stack.func_190926_b()) {
            return;
        }
        ServerNetwork network = this.getServerNetwork();
        boolean bl = trovesDispense = network != null && network.getTrovesDispense();
        int count = player.func_70093_af() ? (trovesDispense ? stack.func_77976_d() : 1) : (trovesDispense ? 1 : stack.func_77976_d());
        stack = this.inventory.extractItem(0, count, false);
        IItemHandler inventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
        if (!result.func_190926_b()) {
            Block.func_180635_a((World)this.field_145850_b, (BlockPos)player.func_180425_c(), (ItemStack)result);
        }
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return this.serializeStack(compound);
    }

    public NBTTagCompound serializeStack(NBTTagCompound compound) {
        compound.func_74782_a("handler_item", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("size_upgrades", (NBTBase)this.sizeUpgrades.serializeNBT());
        compound.func_74782_a("optional_upgrades", (NBTBase)this.optionalUpgrades.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.deserializeStack(compound);
    }

    public void deserializeStack(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("handler_item"));
        this.sizeUpgrades.deserializeNBT(compound.func_74775_l("size_upgrades"));
        this.optionalUpgrades.deserializeNBT(compound.func_74775_l("optional_upgrades"));
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean isSingleStackInventory() {
        return true;
    }

    @Override
    public ItemStack getSingleStack() {
        if (this.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.inventory.getItem().func_77946_l();
        stack.func_190920_e(this.inventory.getCount());
        return stack;
    }

    @Override
    public String getDescriptor() {
        return "Trove";
    }

    @Override
    public String getChestName() {
        return "";
    }

    @Override
    public TroveItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    public SizeUpgradeItemHandler getSizeUpgradesHandler() {
        return this.sizeUpgrades;
    }

    @Override
    public OptionalUpgradesHandler getOptionalUpgradesHandler() {
        return this.optionalUpgrades;
    }

    @Override
    public int getModifiedCapacity() {
        return this.sizeUpgrades.getUpgradesCount();
    }

    @Override
    public boolean handleManipulationInterface(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        player.openGui((Object)ArcaneArchives.instance, 10, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return true;
    }

    @Override
    public Int2IntOpenHashMap getOrCalculateReference() {
        this.result.put(RecipeItemHelper.func_194113_b((ItemStack)this.inventory.getItem()), this.inventory.getCount());
        return this.result;
    }

    @Override
    public IBrazierRouting.BrazierRoutingType getRoutingType() {
        return IBrazierRouting.BrazierRoutingType.NO_NEW_STACKS;
    }

    @Override
    public boolean isTileInvalid() {
        return this.func_145837_r();
    }

    @Override
    public int countEmptySlots() {
        return this.totalEmptySlots();
    }

    @Override
    public int totalEmptySlots() {
        return this.inventory.getMaxCount() - this.inventory.getCount();
    }

    @Override
    public int totalSlots() {
        return 1;
    }

    @Override
    public int slotMultiplier() {
        return 1;
    }

    @Override
    public ItemStack acceptStack(ItemStack stack, boolean simulate) {
        ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)stack, (boolean)simulate);
        this.func_70296_d();
        return result;
    }

    @Override
    public int troveScore(ItemStack stack) {
        if (!ItemUtils.areStacksEqualIgnoreSizeMaybeEmpty(stack, this.inventory.getReference(), this.inventory.isLocked())) {
            return -1;
        }
        if (!this.optionalUpgrades.hasUpgrade(UpgradeType.VOID)) {
            return 4500;
        }
        if (this.inventory.getCount() < this.inventory.getMaxCount()) {
            return 4700;
        }
        return 4000;
    }

    public class TroveItemHandler
    implements ITroveItemHandler,
    INBTSerializable<NBTTagCompound> {
        private int upgrades = 0;
        private int count = 0;
        private ItemStack reference = ItemStack.field_190927_a;
        private RadiantTroveTileEntity tile;

        public TroveItemHandler(RadiantTroveTileEntity tile) {
            this.tile = tile;
        }

        @Override
        public boolean isVoiding() {
            return this.tile.getOptionalUpgradesHandler().hasUpgrade(UpgradeType.VOID);
        }

        @Override
        public boolean isLocked() {
            return this.tile.getOptionalUpgradesHandler().hasUpgrade(UpgradeType.LOCK);
        }

        @Override
        public void update() {
            this.tile.func_73660_a();
        }

        public int getSlots() {
            return 2;
        }

        public void setUpgrades(int upgrades) {
            this.upgrades = upgrades;
        }

        public int getUpgrades() {
            return this.upgrades;
        }

        public Point getTotalUpgradesCount() {
            return new Point(RadiantTroveTileEntity.this.sizeUpgrades.getTotalUpgradesQuantity(), RadiantTroveTileEntity.this.optionalUpgrades.getTotalUpgradesQuantity());
        }

        @Override
        public int getMaxCount() {
            return this.getMaxCount(this.upgrades);
        }

        public int getMaxCount(int upgrades) {
            int base = this.reference.func_190926_b() ? BASE_COUNT : Math.max(this.reference.func_77976_d(), 64) * BASE_MODIFIER;
            return base * (upgrades + 1);
        }

        @Override
        public ItemStack getItemCurrent() {
            if (this.count == 0) {
                return ItemStack.field_190927_a;
            }
            return this.reference;
        }

        @Override
        public ItemStack getReference() {
            return this.reference;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void setCount(int count) {
            this.count = count;
            RadiantTroveTileEntity.this.func_70296_d();
            RadiantTroveTileEntity.this.defaultServerSideUpdate();
        }

        @Override
        public ItemStack getItem() {
            return this.reference;
        }

        @Override
        public void setReference(ItemStack reference) {
            this.reference = reference.func_77946_l();
            this.reference.func_190920_e(1);
            RadiantTroveTileEntity.this.func_70296_d();
            RadiantTroveTileEntity.this.defaultServerSideUpdate();
            this.update();
        }

        @Override
        public boolean isEmpty() {
            return this.isLocked() ? this.count == 0 && this.getReference().func_77973_b() == Items.field_190931_a : this.count == 0;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound result = new NBTTagCompound();
            result.func_74768_a("COUNT", this.count);
            result.func_74782_a("REFERENCE", (NBTBase)this.reference.serializeNBT());
            result.func_74768_a("UPGRADES", this.upgrades);
            return result;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.count = nbt.func_74762_e("COUNT");
            this.reference = new ItemStack(nbt.func_74775_l("REFERENCE"));
            this.upgrades = nbt.func_74762_e("UPGRADES");
        }

        public class Tags {
            public static final String COUNT = "COUNT";
            public static final String REFERENCE = "REFERENCE";
            public static final String UPGRADES = "UPGRADES";
        }
    }

    public static class Tags {
        public static final String HANDLER_ITEM = "handler_item";
        public static final String SIZE_UPGRADES = "size_upgrades";
        public static final String OPTIONAL_UPGRADES = "optional_upgrades";

        private Tags() {
        }
    }
}

