/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.tileentities;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.init.SoundRegistry;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IBrazierRouting;
import com.aranaira.arcanearchives.util.InventoryRoutingUtils;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.PlayerUtil;
import com.aranaira.enderio.base.render.ranged.IRanged;
import com.aranaira.enderio.base.render.ranged.RangeParticle;
import com.aranaira.enderio.core.client.render.BoundingBox;
import epicsquid.mysticallib.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BrazierTileEntity
extends ImmanenceTileEntity
implements IRanged {
    public static int STEP = 10;
    public static long DELAY = 300L;
    private UUID lastUUID = null;
    private long lastClick = -1L;
    private Map<EntityPlayer, ItemStack> playerToStackMap = new ConcurrentHashMap<EntityPlayer, ItemStack>();
    private int radius = 150;
    private boolean subnetworkOnly;
    private FakeHandler fakeHandler = new FakeHandler();
    private boolean showingRange;
    private long lastSound = 0L;
    private Int2ObjectOpenHashMap<ItemCache> itemCache = new Int2ObjectOpenHashMap();
    private List<Runnable> clientHooks = new ArrayList<Runnable>();

    public BrazierTileEntity() {
        this(false);
    }

    public BrazierTileEntity(boolean fake) {
        super("brazier", fake);
        this.itemCache.defaultReturnValue(null);
    }

    @SideOnly(value=Side.CLIENT)
    public void addUpdateHook(Runnable hook) {
        this.clientHooks.add(hook);
    }

    @SideOnly(value=Side.CLIENT)
    public void removeUpdateHook(Runnable hook) {
        this.clientHooks.remove(hook);
    }

    public int getRadius() {
        return this.radius;
    }

    public int reduceRadius() {
        this.radius = Math.max(0, this.radius - STEP);
        return this.radius;
    }

    public int increaseRadius() {
        this.radius = Math.min(300, this.radius + STEP);
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.min(300, Math.max(radius, 0));
    }

    public boolean getNetworkMode() {
        return this.subnetworkOnly;
    }

    public void toggleNetworkMode() {
        this.subnetworkOnly = !this.subnetworkOnly;
    }

    public void setNetworkMode(boolean networkMode) {
        this.subnetworkOnly = networkMode;
    }

    private boolean isFavourite(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        return tag.func_74764_b("Quark:FavoriteItem");
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.fakeHandler) : null);
    }

    private void maybePlaySound() {
        if (ConfigHandler.soundConfig.brazierPickup && ConfigHandler.soundConfig.useSounds && System.currentTimeMillis() - this.lastSound >= DELAY) {
            this.lastSound = System.currentTimeMillis();
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundRegistry.BRAZIER_ABSORB, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void beginInsert(EntityItem item) {
        if (item.field_70170_p.field_72995_K) {
            return;
        }
        if (item.getEntityData().func_74764_b("rejected")) {
            return;
        }
        if (item.field_70128_L) {
            return;
        }
        List<ItemStack> stack = InventoryRoutingUtils.tryInsertItems(this, item.func_92059_d(), false);
        this.maybePlaySound();
        if (!stack.isEmpty()) {
            this.rejectItemStacks(stack, false);
        }
        item.func_70106_y();
    }

    public void rejectItemStacks(List<ItemStack> stacks, boolean simulate) {
        for (ItemStack stack : stacks) {
            this.rejectItemStack(stack, simulate);
        }
    }

    public void rejectItemStack(ItemStack stack, boolean simulate) {
        if (this.field_145850_b.field_72995_K || simulate) {
            return;
        }
        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
        item.field_70179_y = Math.min(0.4f, Math.min((Util.rand.nextFloat() - 0.5f) * 0.6f, 0.2f));
        item.field_70159_w = Math.min(0.4f, Math.min((Util.rand.nextFloat() - 0.5f) * 0.6f, 0.2f));
        item.func_174867_a(20);
        item.getEntityData().func_74757_a("rejected", true);
        this.field_145850_b.func_72838_d((Entity)item);
    }

    public boolean beginInsert(EntityPlayer player, EnumHand hand, EnumFacing facing, boolean simulate) {
        boolean doubleClick = false;
        long diff = System.currentTimeMillis() - this.lastClick;
        ItemStack lastItem = ItemStack.field_190927_a;
        if (player.func_110124_au() == this.lastUUID && diff <= 300L) {
            doubleClick = true;
            lastItem = this.playerToStackMap.getOrDefault(player, ItemStack.field_190927_a);
        } else if (diff > 950L) {
            this.playerToStackMap.clear();
        }
        this.lastUUID = player.func_110124_au();
        this.lastClick = System.currentTimeMillis();
        boolean wasHeld = true;
        ItemStack item = player.func_184586_b(hand).func_77946_l();
        if (item.func_190926_b() && doubleClick) {
            item = lastItem;
            wasHeld = false;
        }
        if (item.func_190926_b() || this.isFavourite(item)) {
            return false;
        }
        if (item.func_77973_b() == ItemRegistry.SCEPTER_MANIPULATION || item.func_77973_b() == ItemRegistry.SCEPTER_MANIPULATION || item.func_77973_b() == ItemRegistry.DEBUG_ORB) {
            return false;
        }
        ServerNetwork network = this.getServerNetwork();
        if (network == null) {
            return false;
        }
        ArrayList<ItemStack> toInsert = new ArrayList<ItemStack>();
        IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        IItemHandler cap = (IItemHandler)item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (wasHeld && cap == null) {
            toInsert.add(Objects.requireNonNull(playerInventory).extractItem(player.field_71071_by.field_70461_c, item.func_190916_E(), false));
        }
        List<Object> remainder = new ArrayList();
        NBTTagCompound tag = ItemUtils.getOrCreateTagCompound(item);
        if (!doubleClick) {
            this.playerToStackMap.put(player, item.func_77946_l());
        } else {
            for (int i = 0; i < playerInventory.getSlots(); ++i) {
                ItemStack inSlot = playerInventory.getStackInSlot(i);
                if (!ItemUtils.areStacksEqualIgnoreSize(inSlot, item)) continue;
                toInsert.add(playerInventory.extractItem(i, inSlot.func_190916_E(), simulate));
            }
        }
        if (!toInsert.isEmpty()) {
            this.maybePlaySound();
            remainder = InventoryRoutingUtils.tryInsertItems(this, item, toInsert, simulate);
        }
        boolean doUpdate = wasHeld;
        if (!remainder.isEmpty()) {
            ArrayList<ItemStack> toThrow = new ArrayList<ItemStack>();
            for (ItemStack itemStack : remainder) {
                ItemStack result;
                if (wasHeld) {
                    result = playerInventory.insertItem(player.field_71071_by.field_70461_c, itemStack, simulate);
                    wasHeld = false;
                } else {
                    result = ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)itemStack, (boolean)simulate);
                }
                if (result.func_190926_b()) continue;
                toThrow.add(result);
            }
            this.rejectItemStacks(toThrow, simulate);
        }
        PlayerUtil.Server.syncInventory((EntityPlayerMP)player);
        return true;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("range", this.radius);
        compound.func_74757_a("subnetwork", this.subnetworkOnly);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("range")) {
            this.radius = compound.func_74762_e("range");
        }
        if (compound.func_74764_b("subnetwork")) {
            this.subnetworkOnly = compound.func_74767_n("subnetwork");
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !this.clientHooks.isEmpty()) {
            this.clientHooks.forEach(Runnable::run);
        }
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    @Override
    public boolean handleManipulationInterface(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        player.openGui((Object)ArcaneArchives.instance, 11, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void toggleShowRange() {
        this.setShowingRange(!this.isShowingRange());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setShowingRange(boolean showingRange) {
        this.showingRange = showingRange;
        if (showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<BrazierTileEntity>(this));
        }
    }

    @Override
    @Nonnull
    public BoundingBox getBounds() {
        return new BoundingBox(this.func_174877_v()).expand(this.radius, 255.0, this.radius);
    }

    @Nullable
    public ItemCache getCachedEntry(ItemStack stack) {
        return this.getCachedEntry(RecipeItemHelper.func_194113_b((ItemStack)stack));
    }

    @Nullable
    public ItemCache getCachedEntry(int packed) {
        return (ItemCache)this.itemCache.get(packed);
    }

    public void cacheInsertion(ItemStack stack, IBrazierRouting route, UUID tileId) {
        int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
        ItemCache existing = (ItemCache)this.itemCache.get(packed);
        if (existing == null || !existing.valid()) {
            this.itemCache.put(RecipeItemHelper.func_194113_b((ItemStack)stack), (Object)new ItemCache(route, tileId));
        } else {
            existing.refresh();
        }
    }

    public static class ShulkerItemHandler
    extends ItemStackHandler {
        public ShulkerItemHandler(NonNullList<ItemStack> stacks) {
            super(stacks);
        }

        public NonNullList<ItemStack> getStacks() {
            return this.stacks;
        }
    }

    public static class ItemCache {
        public static long LIMIT = 1000L;
        private long insertedAt;
        private UUID tileId;
        private WeakReference<IBrazierRouting> weakReference = null;

        public ItemCache(@Nullable IBrazierRouting route, UUID tileId) {
            if (route != null) {
                this.weakReference = new WeakReference<IBrazierRouting>(route);
            }
            this.tileId = tileId;
            this.insertedAt = System.currentTimeMillis();
        }

        @Nullable
        public IBrazierRouting getRoute() {
            if (this.weakReference != null) {
                IBrazierRouting result = (IBrazierRouting)this.weakReference.get();
                if (result != null && !result.isTileInvalid()) {
                    return result;
                }
                return null;
            }
            return null;
        }

        public UUID getTileId() {
            return this.tileId;
        }

        public boolean valid() {
            return System.currentTimeMillis() - this.insertedAt < LIMIT;
        }

        public void refresh() {
            this.insertedAt = System.currentTimeMillis();
        }
    }

    public class FakeHandler
    implements IItemHandlerModifiable {
        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            List<ItemStack> result = InventoryRoutingUtils.tryInsertItems(BrazierTileEntity.this, stack, false);
            BrazierTileEntity.this.rejectItemStacks(result, false);
            BrazierTileEntity.this.maybePlaySound();
        }

        public int getSlots() {
            return 999;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            List<ItemStack> result = InventoryRoutingUtils.tryInsertItems(BrazierTileEntity.this, stack, simulate);
            if (!result.isEmpty()) {
                return result.get(0);
            }
            if (!simulate) {
                BrazierTileEntity.this.maybePlaySound();
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 999;
        }
    }

    public static class Tags {
        public static final String RANGE = "range";
        public static final String SUBNETWORK = "subnetwork";

        private Tags() {
        }
    }
}

