/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.recipe.gct;

import com.aranaira.arcanearchives.api.IGCTRecipe;
import com.aranaira.arcanearchives.api.IGCTRecipeList;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipe;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeWithConditionsCrafter;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeWithCrafter;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GCTRecipeList
implements IGCTRecipeList {
    public static final GCTRecipeList instance = new GCTRecipeList();
    private final LinkedHashMap<ResourceLocation, IGCTRecipe> RECIPE_LIST = new LinkedHashMap();
    private ImmutableList<IGCTRecipe> IMMUTABLE_COPY = null;

    @Override
    public Map<ResourceLocation, IGCTRecipe> getRecipes() {
        return this.RECIPE_LIST;
    }

    @Override
    @Nullable
    public IGCTRecipe getRecipeByOutput(ItemStack output) {
        for (IGCTRecipe recipe : this.RECIPE_LIST.values()) {
            if (!ItemUtils.areStacksEqualIgnoreSize(output, recipe.getRecipeOutput())) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public List<IGCTRecipe> getRecipeList() {
        if (this.IMMUTABLE_COPY == null) {
            this.IMMUTABLE_COPY = ImmutableList.copyOf(this.RECIPE_LIST.values());
        }
        return this.IMMUTABLE_COPY;
    }

    @Override
    public IGCTRecipe makeAndAddRecipe(String name, @Nonnull ItemStack result, Object ... recipe) {
        GCTRecipe newRecipe = new GCTRecipe(name, result, recipe);
        this.addRecipe(newRecipe);
        return newRecipe;
    }

    @Override
    public IGCTRecipe makeAndReplaceRecipe(String name, @Nonnull ItemStack result, Object ... recipe) throws IndexOutOfBoundsException {
        ResourceLocation nameResolved = new ResourceLocation("arcanearchives", name);
        if (!this.RECIPE_LIST.containsKey(nameResolved)) {
            throw new IndexOutOfBoundsException("Key '" + name + "' is not contained in the recipe list; use `makeAndAddRecipe` instead or check your spelling.");
        }
        GCTRecipe newRecipe = new GCTRecipe(name, result, recipe);
        this.addRecipe(newRecipe);
        return newRecipe;
    }

    @Override
    public IGCTRecipe makeAndAddRecipeWithCreatorAndCondition(String name, @Nonnull ItemStack result, Object ... recipe) {
        GCTRecipeWithConditionsCrafter newRecipe = new GCTRecipeWithConditionsCrafter(name, result, recipe);
        this.addRecipe(newRecipe);
        return newRecipe;
    }

    @Override
    public IGCTRecipe makeAndReplaceRecipeWithCreatorAndCondition(String name, @Nonnull ItemStack result, Object ... recipe) throws IndexOutOfBoundsException {
        ResourceLocation nameResolved = new ResourceLocation("arcanearchives", name);
        if (!this.RECIPE_LIST.containsKey(nameResolved)) {
            throw new IndexOutOfBoundsException("Key '" + name + "' is not contained in the recipe list; use `makeAndAddRecipe` instead or check your spelling.");
        }
        GCTRecipeWithConditionsCrafter newRecipe = new GCTRecipeWithConditionsCrafter(name, result, recipe);
        this.addRecipe(newRecipe);
        return newRecipe;
    }

    @Override
    public IGCTRecipe makeAndAddRecipeWithCreator(String name, @Nonnull ItemStack result, Object ... recipe) {
        GCTRecipeWithCrafter newRecipe = new GCTRecipeWithCrafter(name, result, recipe);
        this.addRecipe(newRecipe);
        return newRecipe;
    }

    @Override
    public IGCTRecipe makeAndReplaceRecipeWithCreator(String name, @Nonnull ItemStack result, Object ... recipe) throws IndexOutOfBoundsException {
        ResourceLocation nameResolved = new ResourceLocation("arcanearchives", name);
        if (!this.RECIPE_LIST.containsKey(nameResolved)) {
            throw new IndexOutOfBoundsException("Key '" + name + "' is not contained in the recipe list; use `makeAndAddRecipe` instead or check your spelling.");
        }
        GCTRecipeWithCrafter newRecipe = new GCTRecipeWithCrafter(name, result, recipe);
        this.addRecipe(newRecipe);
        return newRecipe;
    }

    @Override
    public void addRecipe(IGCTRecipe recipe) {
        this.IMMUTABLE_COPY = null;
        this.RECIPE_LIST.put(recipe.getName(), recipe);
    }

    @Override
    @Nullable
    public IGCTRecipe getRecipe(ResourceLocation name) {
        return this.RECIPE_LIST.get(name);
    }

    @Override
    public void removeRecipe(IGCTRecipe recipe) {
        this.IMMUTABLE_COPY = null;
        this.RECIPE_LIST.remove(recipe.getName());
    }

    @Override
    public void removeRecipe(ResourceLocation name) {
        this.IMMUTABLE_COPY = null;
        this.RECIPE_LIST.remove(name);
    }

    @Override
    public ItemStack getOutputByIndex(int index) {
        if (index < 0 || index >= this.RECIPE_LIST.size()) {
            return ItemStack.field_190927_a;
        }
        return this.getRecipeList().get(index).getRecipeOutput().func_77946_l();
    }

    @Override
    @Nullable
    public IGCTRecipe getRecipeByIndex(int index) {
        if (index < 0 || index >= this.RECIPE_LIST.size()) {
            return null;
        }
        return this.getRecipeList().get(index);
    }

    @Override
    public int indexOf(IGCTRecipe recipe) {
        if (recipe == null || !this.RECIPE_LIST.containsKey(recipe.getName())) {
            return -1;
        }
        return this.getRecipeList().indexOf(recipe);
    }

    @Override
    public int size() {
        return this.RECIPE_LIST.size();
    }
}

