/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.recipe.gct;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.api.IGCTRecipe;
import com.aranaira.arcanearchives.api.RecipeIngredientHandler;
import com.aranaira.arcanearchives.recipe.IngredientStack;
import com.aranaira.arcanearchives.recipe.IngredientsMatcher;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeList;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class GCTRecipe
implements IGCTRecipe {
    private final List<IngredientStack> ingredients = new ArrayList<IngredientStack>();
    private final ItemStack result;
    private final ResourceLocation name;

    public GCTRecipe(String name, @Nonnull ItemStack result, Object ... recipe) {
        this(new ResourceLocation("arcanearchives", name), result, recipe);
    }

    public GCTRecipe(ResourceLocation name, @Nonnull ItemStack result, List<IngredientStack> ingredients) {
        this.result = result;
        this.name = name;
        this.ingredients.addAll(ingredients);
    }

    public GCTRecipe(ResourceLocation name, @Nonnull ItemStack result, Object ... recipe) {
        this.result = result.func_77946_l();
        this.name = name;
        int i = 0;
        for (Object stack : recipe) {
            if (stack instanceof ItemStack) {
                this.ingredients.add(new IngredientStack((ItemStack)stack));
            } else if (stack instanceof Item) {
                this.ingredients.add(new IngredientStack((Item)stack));
            } else if (stack instanceof Ingredient) {
                this.ingredients.add(new IngredientStack((Ingredient)stack));
            } else if (stack instanceof String) {
                this.ingredients.add(new IngredientStack((String)stack));
            } else if (stack instanceof IngredientStack) {
                this.ingredients.add((IngredientStack)stack);
            } else if (stack instanceof Block) {
                this.ingredients.add(new IngredientStack((Block)stack));
            } else {
                ArcaneArchives.logger.warn(String.format("Unknown ingredient type for recipe %s, skipped: ingredient %d, %s", name.toString(), i, stack.toString()));
            }
            ++i;
        }
    }

    @Override
    public int getIndex() {
        return GCTRecipeList.instance.indexOf(this);
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public boolean matches(@Nonnull IItemHandler inv) {
        return new IngredientsMatcher(this.ingredients).matches(inv);
    }

    @Override
    public boolean craftable(EntityPlayer player, TileEntity craftingInventory) {
        return true;
    }

    @Override
    public Int2IntMap getMatchingSlots(@Nonnull IItemHandler inv) {
        return new IngredientsMatcher(this.ingredients).getMatchingSlots(inv);
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.result.func_77946_l();
    }

    @Override
    public List<IngredientStack> getIngredients() {
        return this.ingredients;
    }

    @Override
    public ItemStack onCrafted(EntityPlayer player, ItemStack output) {
        return output;
    }

    @Override
    public boolean handleItemResult(World world, EntityPlayer player, TileEntity craftingTile, ItemStack ingredient) {
        boolean doReturn = false;
        IFluidHandlerItem cap = (IFluidHandlerItem)ingredient.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (cap != null && cap.getTankProperties().length > 0) {
            FluidStack toDrain = cap.getTankProperties()[0].getContents();
            cap.drain(toDrain, true);
            ingredient = cap.getContainer();
            doReturn = true;
        }
        if (ingredient.func_77973_b() instanceof ItemFlintAndSteel) {
            ingredient.func_77972_a(1, (EntityLivingBase)player);
            doReturn = true;
        }
        if (doReturn) {
            IItemHandler inventory;
            ItemStack result = ingredient;
            if (craftingTile != null) {
                IItemHandler drawer = (IItemHandler)craftingTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                result = ItemHandlerHelper.insertItemStacked((IItemHandler)drawer, (ItemStack)ingredient, (boolean)false);
            }
            if (!result.func_190926_b() && !(result = ItemHandlerHelper.insertItemStacked((IItemHandler)(inventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)), (ItemStack)result, (boolean)false)).func_190926_b()) {
                Block.func_180635_a((World)world, (BlockPos)player.func_180425_c(), (ItemStack)result);
            }
        }
        return doReturn;
    }

    @Override
    public void consumeAndHandleInventory(IGCTRecipe recipe, IItemHandler inventory, EntityPlayer player, @Nullable TileEntity tile, @Nullable Runnable callback, @Nullable RecipeIngredientHandler handler) {
        for (Int2IntMap.Entry entry : recipe.getMatchingSlots(inventory).int2IntEntrySet()) {
            ItemStack result = inventory.extractItem(entry.getIntKey(), entry.getIntValue(), false);
            if (player.field_70170_p.field_72995_K || handler == null || !handler.test(player.field_70170_p, player, tile, result) || callback == null) continue;
            callback.run();
        }
    }
}

