/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.recipe.fastcrafting;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.api.IArcaneArchivesRecipe;
import com.aranaira.arcanearchives.api.RecipeIngredientHandler;
import com.aranaira.arcanearchives.recipe.IngredientStack;
import com.aranaira.arcanearchives.recipe.IngredientsMatcher;
import com.aranaira.arcanearchives.util.ItemUtils;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class FastCraftingRecipe
implements IArcaneArchivesRecipe {
    private final List<IngredientStack> ingredients = new ArrayList<IngredientStack>();
    private ItemStack result;
    private final IRecipe originalRecipe;
    private final World world;
    private final FakeContainer fakeContainer = new FakeContainer();
    private List<ItemStack> returned = new ArrayList<ItemStack>();

    public FastCraftingRecipe(IRecipe input, World world) {
        this.originalRecipe = input;
        this.world = world;
        HashMap<Ingredient, IngredientStack> ingredientMap = new HashMap<Ingredient, IngredientStack>();
        for (Ingredient ingredient : input.func_192400_c()) {
            if (ingredient == Ingredient.field_193370_a) continue;
            IngredientStack match = null;
            for (Map.Entry entry : ingredientMap.entrySet()) {
                if (!ItemUtils.ingredientsMatch((Ingredient)entry.getKey(), ingredient)) continue;
                match = (IngredientStack)entry.getValue();
                break;
            }
            if (match == null) {
                ingredientMap.put(ingredient, new IngredientStack(ingredient, 1));
                continue;
            }
            match.grow();
        }
        this.ingredients.addAll(ingredientMap.values());
    }

    private InventoryCrafting createMatrix(@Nonnull IItemHandler inv, boolean simulate) {
        int minSize;
        IngredientsMatcher matcher = new IngredientsMatcher(this.ingredients);
        Int2IntMap matchingSlots = matcher.getMatchingSlots(inv);
        for (minSize = 1; minSize <= 3 && !this.originalRecipe.func_194133_a(minSize, minSize); ++minSize) {
        }
        InventoryCrafting matrix = new InventoryCrafting((Container)this.fakeContainer, minSize, minSize);
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        for (Int2IntMap.Entry slot : matchingSlots.int2IntEntrySet()) {
            for (int i = 0; i < slot.getIntValue(); ++i) {
                temp.add(inv.extractItem(slot.getIntKey(), 1, simulate));
            }
        }
        int slot = 0;
        block3: for (Ingredient ingredient : this.originalRecipe.func_192400_c()) {
            if (ingredient == Ingredient.field_193370_a) {
                ++slot;
                continue;
            }
            Iterator iter = temp.iterator();
            while (iter.hasNext()) {
                ItemStack next = (ItemStack)iter.next();
                if (!ingredient.apply(next)) continue;
                iter.remove();
                matrix.func_70299_a(slot, next);
                ++slot;
                continue block3;
            }
        }
        if (!temp.isEmpty()) {
            ArcaneArchives.logger.error("wat");
        }
        return matrix;
    }

    @Override
    public boolean matches(@Nonnull IItemHandler inv) {
        IngredientsMatcher matcher = new IngredientsMatcher(this.ingredients);
        if (!matcher.matches(inv)) {
            return false;
        }
        InventoryCrafting matrix = this.createMatrix(inv, true);
        return this.originalRecipe.func_77569_a(matrix, this.world);
    }

    @Override
    public boolean craftable(EntityPlayer player, IItemHandler inventory) {
        return true;
    }

    @Override
    public Int2IntMap getMatchingSlots(@Nonnull IItemHandler inv) {
        return new IngredientsMatcher(this.ingredients).getMatchingSlots(inv);
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.result.func_77946_l();
    }

    @Override
    public List<IngredientStack> getIngredients() {
        return this.ingredients;
    }

    private void setResult(ItemStack stack) {
        this.result = stack;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public List<ItemStack> getReturned() {
        return this.returned;
    }

    public void consumeAndHandleInventory(IArcaneArchivesRecipe recipe, IItemHandler inventory, EntityPlayer player, @Nullable TileEntity tile, @Nullable Runnable callback, @Nullable RecipeIngredientHandler handler, @Nullable Runnable finalCallback) {
        InventoryCrafting matrix = this.createMatrix(inventory, false);
        InventoryCraftResult craftResult = new InventoryCraftResult();
        SlotCrafting slot = new SlotCrafting(player, matrix, (IInventory)craftResult, 0, 0, 0);
        craftResult.func_193056_a(this.originalRecipe);
        craftResult.func_70299_a(0, this.originalRecipe.func_77572_b(matrix));
        ItemStack result = slot.func_190901_a(player, craftResult.func_70301_a(0));
        this.returned.clear();
        this.returned.add(result);
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            ItemStack inSlot = matrix.func_70304_b(i);
            if (inSlot.func_190926_b()) continue;
            this.returned.add(inSlot);
        }
        if (finalCallback != null) {
            finalCallback.run();
        }
    }

    public static class FakeContainer
    extends Container {
        public void func_75130_a(IInventory inventoryIn) {
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }
}

