/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.recipe;

import com.aranaira.arcanearchives.recipe.IngredientStack;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandler;

public class IngredientsMatcher {
    private final Object2IntOpenHashMap<Ingredient> counts = new Object2IntOpenHashMap();
    private final List<IngredientStack> ingredients;

    public IngredientsMatcher(List<IngredientStack> ingredients) {
        this.ingredients = ingredients;
        this.rebuildCounts();
    }

    public void rebuildCounts() {
        for (IngredientStack ingredient : this.ingredients) {
            int count = ingredient.getCount();
            Ingredient ing = ingredient.getIngredient();
            this.counts.put((Object)ing, count);
        }
    }

    public boolean matches(@Nonnull IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack itemstack = inv.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            for (IngredientStack ingredient : this.ingredients) {
                if (ingredient.getIngredient() == Ingredient.field_193370_a || !ingredient.apply(itemstack)) continue;
                this.account(ingredient.getIngredient(), itemstack);
            }
        }
        return this.counts.isEmpty();
    }

    public void account(Ingredient ingredient, ItemStack stack) {
        if (this.counts.containsKey((Object)ingredient)) {
            int curTotal = this.counts.getInt((Object)ingredient);
            if (curTotal - stack.func_190916_E() <= 0) {
                this.counts.remove((Object)ingredient, (Object)curTotal);
            } else {
                this.counts.put((Object)ingredient, curTotal - stack.func_190916_E());
            }
        }
    }

    public Int2IntMap getMatchingSlots(@Nonnull IItemHandler inv) {
        this.rebuildCounts();
        Int2IntOpenHashMap matchingSlots = new Int2IntOpenHashMap();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack itemstack = inv.getStackInSlot(slot);
            if (itemstack.func_190926_b()) continue;
            for (IngredientStack ingredient : this.ingredients) {
                int discount;
                if (!ingredient.apply(itemstack) || (discount = this.discount(ingredient.getIngredient(), itemstack)) == -1) continue;
                matchingSlots.put(slot, discount);
            }
        }
        return matchingSlots;
    }

    public int discount(Ingredient ingredient, ItemStack stack) {
        int res = -1;
        if (this.counts.containsKey((Object)ingredient)) {
            int neededAmount;
            int thisAmount = stack.func_190916_E();
            if (thisAmount >= (neededAmount = this.counts.getInt((Object)ingredient))) {
                res = neededAmount;
                this.counts.remove((Object)ingredient, (Object)neededAmount);
            } else {
                this.counts.put((Object)ingredient, neededAmount - thisAmount);
                res = thisAmount;
            }
        }
        return res;
    }
}

