/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.network;

import com.aranaira.arcanearchives.api.IGCTRecipe;
import com.aranaira.arcanearchives.inventory.ContainerGemCuttersTable;
import com.aranaira.arcanearchives.network.Handlers;
import com.aranaira.arcanearchives.network.Messages;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeList;
import com.aranaira.arcanearchives.tileentities.GemCuttersTableTileEntity;
import com.aranaira.arcanearchives.util.WorldUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGemCutters {

    public static class LastRecipe
    implements IMessage {
        private IGCTRecipe recipe;

        public LastRecipe() {
        }

        public LastRecipe(IGCTRecipe recipe) {
            this.recipe = recipe;
        }

        public void fromBytes(ByteBuf buf) {
            this.recipe = GCTRecipeList.instance.getRecipe(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.recipe.getIndex());
        }

        public static class Handler
        implements Handlers.ClientHandler<LastRecipe> {
            @Override
            public void processMessage(LastRecipe message, MessageContext ctx) {
                Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
                if (container instanceof ContainerGemCuttersTable) {
                    ((ContainerGemCuttersTable)container).updateLastRecipeFromServer(message.recipe);
                }
            }
        }
    }

    public static class ChangeRecipe
    implements IMessage {
        private ResourceLocation recipe;
        private BlockPos pos;
        private int dimension;

        public ChangeRecipe() {
        }

        public ChangeRecipe(ResourceLocation recipe, BlockPos pos, int dimension) {
            this.recipe = recipe;
            this.pos = pos;
            this.dimension = dimension;
        }

        public void fromBytes(ByteBuf buf) {
            this.recipe = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.dimension = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.recipe.toString());
            buf.writeLong(this.pos.func_177986_g());
            buf.writeInt(this.dimension);
        }

        public static class Handler
        implements Handlers.ServerHandler<ChangeRecipe> {
            @Override
            public void processMessage(ChangeRecipe message, MessageContext ctx) {
                GemCuttersTableTileEntity te = WorldUtil.getTileEntity(GemCuttersTableTileEntity.class, message.dimension, message.pos);
                if (te != null) {
                    te.setRecipe(message.recipe);
                }
            }
        }
    }

    public static class SetRecipeIndex
    extends Messages.TileMessage {
        private int recipeIndex = -1;

        public SetRecipeIndex() {
        }

        public SetRecipeIndex(UUID tileId, int recipeIndex) {
            super(tileId);
            this.recipeIndex = recipeIndex;
        }

        public SetRecipeIndex(BlockPos pos, int dimension, int recipeIndex) {
            super(pos, dimension);
            this.recipeIndex = recipeIndex;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.recipeIndex = buf.readInt();
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            buf.writeInt(this.recipeIndex);
        }

        public static class Handler
        implements Handlers.TileHandlerServer<SetRecipeIndex, GemCuttersTableTileEntity> {
            @Override
            public void processMessage(SetRecipeIndex message, MessageContext ctx, GemCuttersTableTileEntity tile) {
                tile.setRecipe(message.recipeIndex);
                Container container = ctx.getServerHandler().field_147369_b.field_71070_bA;
                if (container instanceof ContainerGemCuttersTable) {
                    ((ContainerGemCuttersTable)container).updateRecipe();
                }
            }
        }
    }
}

