/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.network;

import com.aranaira.arcanearchives.network.Handlers;
import io.netty.buffer.ByteBuf;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketClipboard {

    public static class CopyToClipboard
    implements IMessage {
        private String contents = "";

        public CopyToClipboard(String contents) {
            this.contents = contents;
        }

        public CopyToClipboard() {
        }

        public void fromBytes(ByteBuf buf) {
            this.contents = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.contents);
        }

        public static class Handler
        implements Handlers.ClientHandler<CopyToClipboard> {
            @Override
            public void processMessage(CopyToClipboard message, MessageContext ctx) {
                if (Desktop.isDesktopSupported()) {
                    StringSelection select = new StringSelection(message.contents);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(select, null);
                }
            }
        }
    }
}

