/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.network;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.inventory.handlers.GemSocketHandler;
import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.network.Handlers;
import com.aranaira.arcanearchives.network.Messages;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketArcaneGems {

    public static class RequestRecharge
    implements Messages.EmptyMessageServer<RequestRecharge> {
        @Override
        public void processMessage(RequestRecharge message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            GemUtil.rechargeGems((EntityPlayer)player);
        }
    }

    public static class OpenSocket
    implements Messages.EmptyMessageServer<OpenSocket> {
        @Override
        public void processMessage(OpenSocket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = GemSocketHandler.findSocket((EntityPlayer)player);
            if (!stack.func_190926_b()) {
                player.openGui((Object)ArcaneArchives.instance, 7, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
    }

    public static class Toggle
    implements Messages.EmptyMessageServer<Toggle> {
        @Override
        public void processMessage(Toggle packet, MessageContext context) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            GemUtil.AvailableGemsHandler.HandedGemsHandler handler = GemUtil.getHeldGem((EntityPlayer)player, EnumHand.MAIN_HAND);
            GemUtil.swapToggle(((GemUtil.AvailableGemsHandler)handler).getHeld());
        }
    }

    public static class GemParticle
    implements IMessage {
        private ArcaneGemItem.GemCut cut;
        private ArcaneGemItem.GemColor color;
        private Vec3d pos1;
        private Vec3d pos2;

        public GemParticle() {
        }

        public GemParticle(ArcaneGemItem.GemCut cut, ArcaneGemItem.GemColor color, Vec3d pos1, Vec3d pos2) {
            this.cut = cut;
            this.color = color;
            this.pos1 = pos1;
            this.pos2 = pos2;
        }

        public void fromBytes(ByteBuf buf) {
            this.cut = ArcaneGemItem.GemCut.fromByte(buf.readByte());
            this.color = ArcaneGemItem.GemColor.fromByte(buf.readByte());
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            this.pos1 = new Vec3d(x, y, z);
            x = buf.readDouble();
            y = buf.readDouble();
            z = buf.readDouble();
            this.pos2 = new Vec3d(x, y, z);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte((int)ArcaneGemItem.GemCut.ToByte(this.cut));
            buf.writeByte((int)ArcaneGemItem.GemColor.ToByte(this.color));
            buf.writeDouble(this.pos1.field_72450_a);
            buf.writeDouble(this.pos1.field_72448_b);
            buf.writeDouble(this.pos1.field_72449_c);
            buf.writeDouble(this.pos2.field_72450_a);
            buf.writeDouble(this.pos2.field_72448_b);
            buf.writeDouble(this.pos2.field_72449_c);
        }

        public static class Handler
        implements Handlers.ClientHandler<GemParticle> {
            @Override
            public void processMessage(GemParticle packet, MessageContext context) {
                if (packet.cut == ArcaneGemItem.GemCut.ASSCHER) {
                    if (packet.color == ArcaneGemItem.GemColor.BLUE) {
                        // empty if block
                    }
                } else if (packet.cut == ArcaneGemItem.GemCut.OVAL) {
                    if (packet.color == ArcaneGemItem.GemColor.BLACK) {
                        Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, new Random().nextFloat() * 0.5f + 0.75f);
                    }
                } else if (packet.cut != ArcaneGemItem.GemCut.PENDELOQUE) {
                    if (packet.cut == ArcaneGemItem.GemCut.PAMPEL) {
                        if (packet.color == ArcaneGemItem.GemColor.GREEN) {
                            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_190021_aL, 1.0f, 1.0f);
                        }
                    } else if (packet.cut == ArcaneGemItem.GemCut.TRILLION && packet.color == ArcaneGemItem.GemColor.ORANGE) {
                        Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187616_bj, 1.0f, 1.0f);
                    }
                }
            }
        }
    }
}

