/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.network;

import com.aranaira.arcanearchives.network.Handlers;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.util.ByteUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Messages {

    public static abstract class ConfigStringArrayPacket
    extends ConfigPacket<String[]> {
        public ConfigStringArrayPacket(String[] value) {
            super(value);
        }

        public void fromBytes(ByteBuf buf) {
            int count = buf.readInt();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                values.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            this.setValue(values.toArray(new String[0]));
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(((String[])this.value).length);
            for (String s : (String[])this.value) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
            }
        }
    }

    public static abstract class ConfigStringPacket
    extends ConfigPacket<String> {
        public ConfigStringPacket() {
        }

        public ConfigStringPacket(String value) {
            super(value);
        }

        public void fromBytes(ByteBuf buf) {
            this.setValue(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)this.getValue()));
        }
    }

    public static abstract class ConfigBooleanPacket
    extends ConfigPacket<Boolean> {
        public ConfigBooleanPacket() {
        }

        public ConfigBooleanPacket(Boolean value) {
            super(value);
        }

        public void fromBytes(ByteBuf buf) {
            this.setValue(buf.readBoolean());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(((Boolean)this.getValue()).booleanValue());
        }
    }

    public static abstract class ConfigIntegerPacket
    extends ConfigPacket<Integer> {
        public ConfigIntegerPacket() {
        }

        public ConfigIntegerPacket(Integer value) {
            super(value);
        }

        public void fromBytes(ByteBuf buf) {
            this.setValue(buf.readInt());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(((Integer)this.getValue()).intValue());
        }
    }

    public static abstract class ConfigPacket<T>
    implements IMessage {
        protected T value;

        public ConfigPacket() {
        }

        public ConfigPacket(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }

    public static abstract class EmptyTileMessageServer<T extends TileMessage, V extends ImmanenceTileEntity>
    extends TileMessage
    implements Handlers.TileHandlerServer<T, V>,
    EmptyMessage<T> {
        public EmptyTileMessageServer() {
        }

        public EmptyTileMessageServer(UUID tileId) {
            super(tileId);
        }
    }

    public static abstract class TileMessage
    implements IMessage {
        private UUID tileId = null;
        private BlockPos pos = null;
        private int dimension = -9999;

        public TileMessage() {
        }

        public TileMessage(UUID tileId) {
            this.tileId = tileId;
        }

        public TileMessage(BlockPos pos, int dimension) {
            this.pos = pos;
            this.dimension = dimension;
        }

        public void fromBytes(ByteBuf buf) {
            boolean uuid = buf.readBoolean();
            if (uuid) {
                this.tileId = ByteUtils.readUUID(buf);
            } else {
                this.pos = BlockPos.func_177969_a((long)buf.readLong());
                this.dimension = buf.readInt();
            }
        }

        public void toBytes(ByteBuf buf) {
            if (this.tileId != null) {
                buf.writeBoolean(true);
                ByteUtils.writeUUID(buf, this.tileId);
            } else {
                buf.writeBoolean(false);
                buf.writeLong(this.pos.func_177986_g());
                buf.writeInt(this.dimension);
            }
        }

        public UUID getTileId() {
            return this.tileId;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getDimension() {
            return this.dimension;
        }
    }

    public static interface EmptyMessageClient<T extends IMessage>
    extends EmptyMessage<T>,
    Handlers.ClientHandler<T> {
    }

    public static interface EmptyMessageServer<T extends IMessage>
    extends EmptyMessage<T>,
    Handlers.ServerHandler<T> {
    }

    public static interface EmptyMessage<T extends IMessage>
    extends IMessage,
    Handlers.BaseHandler<T> {
        default public void fromBytes(ByteBuf buf) {
        }

        default public void toBytes(ByteBuf buf) {
        }
    }
}

