/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.templates;

import com.aranaira.arcanearchives.blocks.RadiantResonator;
import com.aranaira.arcanearchives.blocks.templates.BlockTemplate;
import com.aranaira.arcanearchives.blocks.unused.MatrixCrystalCore;
import com.aranaira.arcanearchives.data.ClientNetwork;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.ServerNetwork;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemBlockTemplate
extends ItemBlock {
    private BlockTemplate blockTemplate;

    public ItemBlockTemplate(@Nonnull BlockTemplate block) {
        super((Block)block);
        this.blockTemplate = block;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        int totalResonators = 0;
        int totalCores = 0;
        int placeLimit = this.blockTemplate.getPlaceLimit();
        if (placeLimit != -1) {
            Object network;
            if (world.field_72995_K) {
                network = DataHelper.getClientNetwork(player.func_110124_au());
                totalResonators = ((ClientNetwork)network).getTotalResonators();
                totalCores = ((ClientNetwork)network).getTotalCores();
            } else {
                network = DataHelper.getServerNetwork(player.func_110124_au());
                if (network == null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.error.invalidnetwork", new Object[0]), true);
                    return EnumActionResult.FAIL;
                }
                totalResonators = ((ServerNetwork)network).getTotalResonators();
                totalCores = ((ServerNetwork)network).getTotalCores();
            }
            if (this.blockTemplate instanceof RadiantResonator && totalResonators >= placeLimit || this.blockTemplate instanceof MatrixCrystalCore && totalCores >= placeLimit) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.error.toomanyplaced", new Object[]{this.blockTemplate.getPlaceLimit(), this.blockTemplate.getNameComponent()}), true);
                }
                return EnumActionResult.FAIL;
            }
        }
        BlockPos up = pos.func_177984_a();
        int height = this.blockTemplate.getSize().height;
        if (up.func_177956_o() + height > world.func_72800_K()) {
            if (!world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.error.aboveworld", new Object[]{this.blockTemplate.getNameComponent()}), true);
            }
            return EnumActionResult.FAIL;
        }
        if (this.blockTemplate.hasAccessors()) {
            boolean safe = true;
            EnumFacing dir = EnumFacing.func_176733_a((double)(player.field_70177_z - 90.0f));
            for (BlockPos point : this.blockTemplate.calculateAccessors(world, up, dir)) {
                IBlockState newState = world.func_180495_p(point);
                Block newBlock = newState.func_177230_c();
                if (newBlock.isAir(newState, (IBlockAccess)world, point) || newBlock.func_176200_f((IBlockAccess)world, point)) continue;
                safe = false;
                break;
            }
            if (!safe) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.error.notenoughspace", new Object[]{this.blockTemplate.getNameComponent()}), true);
                }
                return EnumActionResult.FAIL;
            }
        }
        if (placeLimit == -1 || world.field_72995_K) {
            // empty if block
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }
}

