/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.itemblocks;

import com.aranaira.arcanearchives.inventory.handlers.OptionalUpgradesHandler;
import com.aranaira.arcanearchives.inventory.handlers.TroveItemBlockItemHandler;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import com.aranaira.arcanearchives.types.enums.UpgradeType;
import com.aranaira.arcanearchives.util.ItemUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RadiantTroveItem
extends ItemBlock {
    public RadiantTroveItem(Block block) {
        super(block);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TroveItemBlockItemHandler(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag = ItemUtils.getOrCreateTagCompound(stack);
        if (tag.func_74764_b("handler_item")) {
            NBTTagCompound incoming = tag.func_74775_l("handler_item");
            int count = incoming.func_74762_e("COUNT");
            ItemStack stored = new ItemStack(incoming.func_74775_l("REFERENCE"));
            int maxCapacity = (incoming.func_74762_e("UPGRADES") + 1) * RadiantTroveTileEntity.BASE_COUNT;
            String displayName = stored.func_82833_r();
            if (stored.func_82837_s()) {
                displayName = TextFormatting.ITALIC + displayName;
            }
            displayName = stored.func_77973_b().getForgeRarity(stored).getColor() + displayName + TextFormatting.RESET;
            tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.trove.items", (Object[])new Object[]{displayName}));
            tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.trove.contains", (Object[])new Object[]{count, maxCapacity}));
            OptionalUpgradesHandler optionals = new OptionalUpgradesHandler();
            optionals.deserializeNBT(tag.func_74775_l("optional_upgrades"));
            if (optionals.hasUpgrade(UpgradeType.VOID)) {
                tooltip.add(TextFormatting.DARK_PURPLE + "" + TextFormatting.BOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.trove.voiding", (Object[])new Object[0]));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

