/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems.trillion;

import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.util.ItemUtils;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StormwayItem
extends ArcaneGemItem {
    public static final String NAME = "stormway";

    public StormwayItem() {
        super(NAME, ArcaneGemItem.GemCut.TRILLION, ArcaneGemItem.GemColor.YELLOW, 30, 150);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.gemcharge", (Object[])new Object[0]) + ": " + this.getTooltipData(stack));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.stormway", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.recharge.stormway", (Object[])new Object[0]));
    }

    @Override
    public boolean hasToggleMode() {
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        World world = entityItem.field_70170_p;
        if (!world.field_72995_K && world.func_72896_J() && world.func_175710_j(new BlockPos((Entity)entityItem)) && GemUtil.getCharge(entityItem) < GemUtil.getMaxCharge(entityItem)) {
            GemUtil.restoreCharge(entityItem, -1);
            world.func_184134_a(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 0.5f, false);
            return true;
        }
        return super.onEntityItemUpdate(entityItem);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        GemUtil.AvailableGemsHandler.HandedGemsHandler handler;
        if (!world.field_72995_K && ((GemUtil.AvailableGemsHandler)(handler = GemUtil.getHeldGem(player, hand))).getHeld() != null && GemUtil.getCharge(((GemUtil.AvailableGemsHandler)handler).getHeld()) > 0) {
            EnumFacing facing;
            BlockPos pos;
            Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.field_70131_O, player.field_70161_v);
            Vec3d dir = player.func_70040_Z();
            Vec3d rayTarget = new Vec3d(start.field_72450_a + dir.field_72450_a * 30.0, start.field_72448_b + dir.field_72448_b * 30.0, start.field_72449_c + dir.field_72449_c * 30.0);
            RayTraceResult ray = world.func_147447_a(start, rayTarget, false, true, false);
            if (ray != null && world.func_175710_j((pos = ray.func_178782_a()).func_177972_a(facing = ray.field_178784_b))) {
                Vec3d end = new Vec3d((double)pos.func_177972_a(facing).func_177958_n(), (double)pos.func_177972_a(facing).func_177956_o(), (double)pos.func_177972_a(facing).func_177952_p());
                world.func_72838_d((Entity)new EntityLightningBolt(world, end.field_72450_a, end.field_72448_b, end.field_72449_c, false));
                GemUtil.consumeCharge(((GemUtil.AvailableGemsHandler)handler).getHeld(), 1);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public static void setStrikeCooldownTimer(GemUtil.GemStack stack) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack.getStack());
        nbt.func_74772_a("cooldown", System.currentTimeMillis());
    }

    public static boolean canBeStruck(GemUtil.GemStack stack) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack.getStack());
        if (nbt.func_74764_b("cooldown")) {
            return nbt.func_74763_f("cooldown") + 1000L < System.currentTimeMillis();
        }
        return true;
    }
}

