/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems.pendeloque;

import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketArcaneGems;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.common.tiles.crafting.TileCrucible;
import vazkii.botania.api.item.IPetalApothecary;

public class RivertearItem
extends ArcaneGemItem {
    public static final String NAME = "rivertear";

    public RivertearItem() {
        super(NAME, ArcaneGemItem.GemCut.PENDELOQUE, ArcaneGemItem.GemColor.BLUE, 25, 100);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.gemcharge", (Object[])new Object[0]) + ": " + this.getTooltipData(stack));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.rivertear", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.recharge.rivertear", (Object[])new Object[0]));
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        World world = entityItem.field_70170_p;
        if (!world.field_72995_K && entityItem.func_70090_H() && GemUtil.getCharge(entityItem) < GemUtil.getMaxCharge(entityItem)) {
            GemUtil.restoreCharge(entityItem, -1);
            world.func_184134_a(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 0.5f, false);
            return true;
        }
        return super.onEntityItemUpdate(entityItem);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        GemUtil.AvailableGemsHandler.HandedGemsHandler handler;
        if (!world.field_72995_K && GemUtil.getCharge(((GemUtil.AvailableGemsHandler)(handler = GemUtil.getHeldGem(player, hand))).getHeld()) > 0) {
            Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            Vec3d dir = player.func_70040_Z();
            Vec3d rayTarget = new Vec3d(start.field_72450_a + dir.field_72450_a * 40.0, start.field_72448_b + dir.field_72448_b * 40.0, start.field_72449_c + dir.field_72449_c * 40.0);
            RayTraceResult ray = world.func_147447_a(start, rayTarget, false, true, false);
            if (ray != null) {
                TileCrucible tc;
                IPetalApothecary ipa;
                BlockPos pos = ray.func_178782_a();
                boolean isPetalApothecary = false;
                boolean isCrucible = false;
                if (Loader.isModLoaded((String)"botania") && (ipa = WorldUtil.getTileEntity(IPetalApothecary.class, player.field_71093_bK, pos)) != null) {
                    isPetalApothecary = true;
                }
                if (Loader.isModLoaded((String)"thaumcraft") && (tc = WorldUtil.getTileEntity(TileCrucible.class, player.field_71093_bK, pos)) != null) {
                    isCrucible = true;
                }
                if (!isPetalApothecary && !isCrucible) {
                    EnumFacing facing = ray.field_178784_b;
                    Vec3d end = new Vec3d((double)pos.func_177972_a(facing).func_177958_n(), (double)pos.func_177972_a(facing).func_177956_o(), (double)pos.func_177972_a(facing).func_177952_p());
                    IBlockState water = Blocks.field_150355_j.func_176223_P();
                    world.func_175656_a(pos.func_177972_a(facing), water);
                    Blocks.field_150355_j.func_189540_a(water, world, pos.func_177972_a(facing), (Block)Blocks.field_150355_j, null);
                    if (!player.field_71075_bZ.field_75098_d) {
                        GemUtil.consumeCharge(((GemUtil.AvailableGemsHandler)handler).getHeld(), 1);
                    }
                    PacketArcaneGems.GemParticle packet = new PacketArcaneGems.GemParticle(this.cut, this.color, start, end);
                    NetworkRegistry.TargetPoint tp = new NetworkRegistry.TargetPoint(player.field_71093_bK, start.field_72450_a, start.field_72448_b, start.field_72449_c, 160.0);
                    Networking.CHANNEL.sendToAllTracking((IMessage)packet, tp);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

