/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems.pampel;

import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketArcaneGems;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Elixirspindle
extends ArcaneGemItem {
    public static final String NAME = "elixirspindle";

    public Elixirspindle() {
        super(NAME, ArcaneGemItem.GemCut.PAMPEL, ArcaneGemItem.GemColor.PURPLE, 5, 20);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.gemcharge", (Object[])new Object[0]) + ": " + this.getTooltipData(stack));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.elixirspindle", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.recharge.elixirspindle", (Object[])new Object[0]));
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            GemUtil.AvailableGemsHandler.HandedGemsHandler handler = GemUtil.getHeldGem(player, hand);
            GemUtil.GemStack gem = ((GemUtil.AvailableGemsHandler)handler).getHeld();
            this.recharge(world, player, gem);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public boolean recharge(World world, EntityPlayer player, GemUtil.GemStack gem) {
        if (gem != null && GemUtil.getCharge(gem) == 0 && gem.getItem() == ItemRegistry.ELIXIRSPINDLE) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_77973_b() != Items.field_151075_bm) continue;
                int numConsumed = Math.min(stack.func_190916_E(), 5);
                this.informPlayerOfItemConsumption(player, gem, stack, numConsumed);
                GemUtil.restoreCharge(gem, numConsumed);
                stack.func_190918_g(numConsumed);
                Vec3d pos = player.func_174791_d().func_72441_c(0.0, 1.0, 0.0);
                PacketArcaneGems.GemParticle packet = new PacketArcaneGems.GemParticle(this.cut, this.color, pos, pos);
                Networking.sendToAllTracking((IMessage)packet, (Entity)player);
                return true;
            }
        }
        return this.tryRechargingWithPowder(world, player, gem);
    }
}

