/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems.oval;

import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TransferstoneItem
extends ArcaneGemItem {
    public static final String NAME = "transferstone";

    public TransferstoneItem() {
        super(NAME, ArcaneGemItem.GemCut.OVAL, ArcaneGemItem.GemColor.BLUE, 1, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.gemcharge", (Object[])new Object[0]) + ": " + this.getTooltipData(stack));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.transferstone", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.recharge.transferstone", (Object[])new Object[0]));
        if (nbt.func_74764_b("troveLocation")) {
            BlockPos bp = BlockPos.func_177969_a((long)nbt.func_74763_f("troveLocation"));
            tooltip.add("Linked to " + bp.func_177958_n() + "/" + bp.func_177956_o() + "/" + bp.func_177952_p() + " in \"" + DimensionType.func_186069_a((int)nbt.func_74762_e("dimID")).func_186065_b() + "\"");
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean hasToggleMode() {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af() && world.func_180495_p(pos).func_177230_c() == BlockRegistry.RADIANT_TROVE) {
                TransferstoneItem.setLinkedTrove(player.func_184614_ca(), pos, player.field_71093_bK);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static void setLinkedTrove(ItemStack stack, BlockPos pos, int dimension) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        nbt.func_74772_a("troveLocation", pos.func_177986_g());
        nbt.func_74768_a("troveDimID", dimension);
        stack.func_77982_d(nbt);
    }

    public static ItemStack extractLinkedItem(ItemStack stack, boolean doFullStack) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        ItemStack output = null;
        if (nbt.func_74764_b("troveLocation")) {
            RadiantTroveTileEntity te;
            BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("troveLocation"));
            int dimID = nbt.func_74762_e("troveDimID");
            if (WorldUtil.isChunkLoaded((World)DimensionManager.getWorld((int)dimID), pos) && (te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, dimID, pos)) != null) {
                output = doFullStack ? te.getInventory().extractItem(0, 64, false) : te.getInventory().extractItem(0, 1, false);
            }
        }
        return output;
    }

    public static ItemStack insertLinkedItem(ItemStack stack) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        ItemStack output = null;
        if (nbt.func_74764_b("troveLocation")) {
            RadiantTroveTileEntity te;
            BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("troveLocation"));
            int dimID = nbt.func_74762_e("troveDimID");
            if (WorldUtil.isChunkLoaded((World)DimensionManager.getWorld((int)dimID), pos) && (te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, dimID, pos)) != null) {
                RadiantTroveTileEntity.TroveItemHandler handler = te.getInventory();
                handler.insertItem(1, stack, false);
            }
        }
        return output;
    }

    public static Item getLinkedItem(ItemStack stack) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        Item output = null;
        if (nbt.func_74764_b("troveLocation")) {
            RadiantTroveTileEntity te;
            BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("troveLocation"));
            int dimID = nbt.func_74762_e("troveDimID");
            if (WorldUtil.isChunkLoaded((World)DimensionManager.getWorld((int)dimID), pos) && (te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, dimID, pos)) != null) {
                output = te.getInventory().extractItem(0, 1, true).func_77973_b();
            }
        }
        return output;
    }
}

