/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems.oval;

import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketArcaneGems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MunchstoneItem
extends ArcaneGemItem {
    public static final String NAME = "munchstone";
    public static EdibleBlock[] entries;
    public static final String[] DEFAULT_ENTRIES;

    public MunchstoneItem() {
        super(NAME, ArcaneGemItem.GemCut.OVAL, ArcaneGemItem.GemColor.BLACK, 60, 240);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.gemcharge", (Object[])new Object[0]) + ": " + this.getTooltipData(stack));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.munchstone", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.recharge.munchstone", (Object[])new Object[0]));
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            GemUtil.AvailableGemsHandler.HandedGemsHandler handler = GemUtil.getHeldGem(player, hand);
            GemUtil.GemStack gem = ((GemUtil.AvailableGemsHandler)handler).getHeld();
            this.recharge(world, player, gem);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public boolean recharge(World world, EntityPlayer player, GemUtil.GemStack gem) {
        if (gem != null && GemUtil.getCharge(gem) == 0) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_77973_b() != Items.field_151100_aR || stack.func_77960_j() != 15) continue;
                int numConsumed = 5;
                if (numConsumed > stack.func_190916_E()) {
                    numConsumed = stack.func_190916_E();
                }
                GemUtil.restoreCharge(gem, numConsumed * 12);
                stack.func_190918_g(numConsumed);
                Vec3d pos = player.func_174791_d().func_72441_c(0.0, 1.0, 0.0);
                PacketArcaneGems.GemParticle packet = new PacketArcaneGems.GemParticle(this.cut, this.color, pos, pos);
                Networking.sendToAllTracking((IMessage)packet, (Entity)player);
                return true;
            }
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        GemUtil.AvailableGemsHandler.HandedGemsHandler handler;
        if (!world.field_72995_K && ((GemUtil.AvailableGemsHandler)(handler = GemUtil.getHeldGem(player, hand))).getHeld() != null && GemUtil.getCharge(((GemUtil.AvailableGemsHandler)handler).getHeld()) > 0) {
            Block block = world.func_180495_p(pos).func_177230_c();
            for (EdibleBlock eb : this.getConfig()) {
                int chargeConsumed;
                if (eb == null || block != eb.block) continue;
                int hungerLevel = player.func_71024_bL().func_75116_a();
                int hungerMod = eb.hungerValue;
                float saturationLevel = player.func_71024_bL().func_75115_e();
                float saturationMod = eb.saturationValue;
                saturationLevel += eb.saturationValue;
                if ((hungerLevel += eb.hungerValue) + hungerMod > 20) {
                    hungerMod = MathHelper.func_76125_a((int)(20 - hungerLevel), (int)0, (int)20);
                }
                if (saturationLevel + saturationMod > 20.0f) {
                    saturationMod = MathHelper.func_76131_a((float)(20.0f - saturationLevel), (float)0.0f, (float)20.0f);
                }
                if ((chargeConsumed = hungerMod + (int)saturationMod) > 0) {
                    player.func_71024_bL().func_75122_a(eb.hungerValue, eb.saturationValue);
                    GemUtil.consumeCharge(((GemUtil.AvailableGemsHandler)handler).getHeld(), chargeConsumed);
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    PacketArcaneGems.GemParticle packet = new PacketArcaneGems.GemParticle(this.cut, this.color, MunchstoneItem.blockPosToVector(pos, true), MunchstoneItem.blockPosToVector(pos, true));
                    Networking.sendToAllTracking((IMessage)packet, (Entity)player);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public EdibleBlock[] getConfig() {
        if (entries == null) {
            int i;
            EdibleBlock[] output = new EdibleBlock[ConfigHandler.ArsenalConfig.MunchstoneValidEntries.length];
            ArrayList<EdibleBlock> verifiedEBs = new ArrayList<EdibleBlock>();
            for (i = 0; i < ConfigHandler.ArsenalConfig.MunchstoneValidEntries.length; ++i) {
                String entry = ConfigHandler.ArsenalConfig.MunchstoneValidEntries[i];
                String[] parse = entry.split(",");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parse[0].trim()));
                int feed = 0;
                try {
                    feed = Integer.parseInt(parse[1].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EdibleBlock eb = new EdibleBlock(block, feed, 1.0f);
                if (block == Blocks.field_150350_a || feed <= 0) continue;
                verifiedEBs.add(eb);
            }
            for (i = 0; i < verifiedEBs.size(); ++i) {
                output[i] = (EdibleBlock)verifiedEBs.get(i);
            }
            entries = output;
        }
        return entries;
    }

    static {
        DEFAULT_ENTRIES = new String[]{"minecraft:log, 4", "minecraft:log2, 4", "minecraft:leaves, 2", "minecraft:leaves2, 2", "minecraft:hay_block, 15", "minecraft:melon_block, 15", "minecraft:brown_mushroom_block, 8", "minecraft:brown_mushroom, 4", "minecraft:red_mushroom_block, 8", "minecraft:red_mushroom, 4", "minecraft:nether_wart_block, 15", "minecraft:nether_wart, 4", "minecraft:chorus_flower, 6", "minecraft:chorus_plant, 6", "minecraft:cactus, 6", "minecraft:cocoa, 4", "minecraft:deadbush, 2", "minecraft:double_plant, 2", "minecraft:pumpkin, 15", "minecraft:lit_pumpkin, 16", "minecraft:pumpkin_stem, 4", "minecraft:melon_stem, 4", "minecraft:red_flower, 2", "minecraft:yellow_flower, 2", "minecraft:reeds, 4", "minecraft:sapling, 2", "minecraft:tallgrass, 1", "minecraft:vine, 2", "minecraft:waterlily, 4", "minecraft:wheat, 4", "minecraft:potatoes, 4", "minecraft:carrots, 4", "minecraft:beetroots, 4", "mysticalworld:aubergine_crop, 4", "mysticalworld:thatch, 3", "betternether:agave, 3", "betternether:barrel_cactus, 4", "betternether:black_bush, 1", "betternether:egg_plant, 1", "betternether:gray_mold, 1", "betternether:lucis_spore, 1", "betternether:nether_cactus, 1", "betternether:nether_grass, 1", "betternether:nether_reed, 1", "betternether:orange_mushroom, 1", "betternether:red_mold, 1", "roots:baffle_cap_mushroom, 4", "roots:baffle_cap_huge_stem, 8", "roots:baffle_cap_huge_top, 8", "roots:moonglow_crop, 4", "roots:pereskia_crop, 4", "roots:spirit_herb_crop, 4", "roots:wildroot_crop, 4", "roots:wildewheet_crop, 4", "roots:cloud_berry_crop, 4", "roots:infernal_bulb_crop, 4", "roots:dewgonia_crop, 4", "roots:stalicripe_crop, 4", "roots:wildwood_log, 8", "roots:wildwood_leaves, 4", "roots:wildwood_sapling, 20", "rustic:log, 4", "rustic:sapling, 2", "rustic:leaves, 2", "rustic:leaves_apple, 3", "rustic:wildberry_bush, 3", "rustic:grape_stem, 4", "rustic:aloe_vera, 3", "rustic:blood_orchid, 3", "rustic:chamomile, 3", "rustic:cohosh, 3", "rustic:deathstalk_mushroom, 3", "rustic:horsetail, 3", "rustic:mooncap_mushroom, 3", "rustic:wind_thistle, 3", "rustic:cloudsbluff, 3", "rustic:core_root, 3", "rustic:ginseng, 3", "rustic:marsh_mallow, 3", "thaumcraft:sapling_greatwood, 2", "thaumcraft:sapling_silverwood, 3", "thaumcraft:log_greatwood, 4", "thaumcraft:log_silverwood, 5", "thaumcraft:leaves_greatwood, 2", "thaumcraft:leaves_silverwood, 3", "thaumcraft:cinderpearl, 3", "thaumcraft:shimmerleaf, 3", "thaumcraft:vishroom, 3"};
    }

    public static class EdibleBlock {
        public Block block;
        public int hungerValue;
        float saturationValue;

        public EdibleBlock(Block block, int hungerValue, float saturationValue) {
            this.block = block;
            this.hungerValue = hungerValue;
            this.saturationValue = saturationValue;
        }
    }
}

