/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems;

import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.integration.baubles.BaubleGemUtil;
import com.aranaira.arcanearchives.inventory.ContainerGemSocket;
import com.aranaira.arcanearchives.inventory.handlers.GemSocketHandler;
import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.util.ItemUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.Loader;

public class GemUtil {
    public static void setUpgrades(ItemStack stack, byte upgrades) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        nbt.func_74774_a("upgrades", upgrades);
    }

    public static void setUpgrades(ItemStack stack, boolean matterUpgrade, boolean powerUpgrade, boolean spaceUpgrade, boolean timeUpgrade) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        byte upgrades = 0;
        if (matterUpgrade) {
            upgrades = (byte)(upgrades | 1);
        }
        if (powerUpgrade) {
            upgrades = (byte)(upgrades | 2);
        }
        if (spaceUpgrade) {
            upgrades = (byte)(upgrades | 4);
        }
        if (timeUpgrade) {
            upgrades = (byte)(upgrades | 8);
        }
        nbt.func_74774_a("upgrades", upgrades);
    }

    public static byte getUpgrades(ItemStack stack) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        if (nbt.func_74764_b("upgrades")) {
            return nbt.func_74771_c("upgrades");
        }
        return 0;
    }

    public static boolean hasUpgrade(ItemStack stack, ArcaneGemItem.GemUpgrades query) {
        byte upgrades = GemUtil.getUpgrades(stack);
        switch (query) {
            case MATTER: {
                return (upgrades & 1) == 1;
            }
            case POWER: {
                return (upgrades & 2) == 2;
            }
            case SPACE: {
                return (upgrades & 4) == 4;
            }
            case TIME: {
                return (upgrades & 8) == 8;
            }
        }
        return false;
    }

    public static int getMaxCharge(EntityItem stack) {
        return GemUtil.getMaxCharge(stack.func_92059_d());
    }

    public static int getMaxCharge(GemStack stack) {
        return GemUtil.getMaxCharge(stack.getStack());
    }

    public static int getTooltipMaxCharge(ItemStack stack) {
        return GemUtil.getMaxCharge(stack);
    }

    private static int getMaxCharge(ItemStack stack) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        boolean hasPowerUpgrade = GemUtil.hasUpgrade(stack, ArcaneGemItem.GemUpgrades.POWER);
        ArcaneGemItem item = (ArcaneGemItem)stack.func_77973_b();
        if (hasPowerUpgrade) {
            return item.getMaxChargeUpgraded();
        }
        return item.getMaxChargeNormal();
    }

    public static int getCharge(EntityItem stack) {
        return GemUtil.getCharge(stack.func_92059_d());
    }

    public static int getCharge(GemStack stack) {
        return GemUtil.getCharge(stack.getStack());
    }

    public static int getTooltipCharge(ItemStack stack) {
        return GemUtil.getCharge(stack);
    }

    private static int getCharge(ItemStack stack) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        if (nbt.func_74764_b("charge")) {
            return nbt.func_74762_e("charge");
        }
        int maximum = GemUtil.getMaxCharge(stack);
        nbt.func_74768_a("charge", maximum);
        return maximum;
    }

    public static void rechargeGems(EntityPlayer player) {
        AvailableGemsHandler handler = GemUtil.getAvailableGems(player);
        for (GemStack gem : handler) {
            gem.getArcaneGemItem().recharge(player.field_70170_p, player, gem);
        }
    }

    public static float getChargePercent(ItemStack stack) {
        int current = GemUtil.getCharge(stack);
        int maximum = GemUtil.getMaxCharge(stack);
        return (float)current / (float)maximum;
    }

    public static boolean manuallyRestoreCharge(ItemStack gem, int amount) {
        return GemUtil.restoreCharge(gem, amount);
    }

    public static boolean restoreCharge(EntityItem gem, int amount) {
        return GemUtil.restoreCharge(gem.func_92059_d(), amount);
    }

    public static boolean restoreCharge(GemStack gem, int amount) {
        boolean result = GemUtil.restoreCharge(gem.getStack(), amount);
        gem.markDirty();
        return result;
    }

    private static boolean restoreCharge(ItemStack stack, int amount) {
        int currentCharge;
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        int maximum = GemUtil.getMaxCharge(stack);
        if (nbt.func_74764_b("charge")) {
            currentCharge = nbt.func_74762_e("charge");
        } else {
            currentCharge = maximum;
            nbt.func_74768_a("charge", currentCharge);
        }
        if (amount == -1) {
            currentCharge = maximum;
        } else if ((currentCharge += amount) > maximum) {
            currentCharge = maximum;
        }
        nbt.func_74768_a("charge", currentCharge);
        return currentCharge >= maximum;
    }

    public static boolean consumeCharge(GemStack gem, int amount) {
        boolean result = GemUtil.consumeCharge(gem.getStack(), amount);
        gem.markDirty();
        if (!result) {
            EntityPlayer player = gem.getHandler().getPlayer();
            gem.getArcaneGemItem().recharge(player.field_70170_p, player, gem);
        }
        return result;
    }

    private static boolean consumeCharge(ItemStack stack, int amount) {
        int currentCharge;
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        if (nbt.func_74764_b("charge")) {
            currentCharge = nbt.func_74762_e("charge");
        } else {
            currentCharge = GemUtil.getMaxCharge(stack);
            nbt.func_74768_a("charge", currentCharge);
        }
        if (amount < -1) {
            return currentCharge < 0;
        }
        if (amount == -1) {
            currentCharge = 0;
        } else if ((currentCharge -= amount) < 0) {
            currentCharge = 0;
        }
        nbt.func_74768_a("charge", currentCharge);
        return currentCharge > 0;
    }

    public static boolean hasUnlimitedCharge(ItemStack stack) {
        if (GemUtil.getMaxCharge(stack) == 0) {
            return true;
        }
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        if (nbt.func_74764_b("infinite")) {
            return nbt.func_74767_n("infinity");
        }
        nbt.func_74757_a("infinite", false);
        return false;
    }

    public static boolean isChargeEmpty(ItemStack stack) {
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
        if (!GemUtil.hasUnlimitedCharge(stack)) {
            return GemUtil.getCharge(stack) == 0;
        }
        return false;
    }

    public static boolean isToggledOn(GemStack stack) {
        return GemUtil.isToggledOn(stack.getStack());
    }

    public static boolean isToggledOn(ItemStack stack) {
        ArcaneGemItem agi = (ArcaneGemItem)stack.func_77973_b();
        if (agi.hasToggleMode()) {
            NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
            if (!nbt.func_74764_b("toggle")) {
                nbt.func_74757_a("toggle", false);
            }
            return nbt.func_74767_n("toggle");
        }
        return false;
    }

    public static void swapToggle(GemStack stack) {
        GemUtil.swapToggle(stack.getStack());
        stack.markDirty();
    }

    private static void swapToggle(ItemStack stack) {
        ArcaneGemItem gem = (ArcaneGemItem)stack.func_77973_b();
        if (gem.hasToggleMode()) {
            NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
            if (!nbt.func_74764_b("toggle")) {
                nbt.func_74757_a("toggle", true);
            } else {
                nbt.func_74757_a("toggle", !nbt.func_74767_n("toggle"));
            }
            stack.func_77982_d(nbt);
        }
    }

    public static void setToggle(GemStack stack, boolean state) {
        GemUtil.setToggle(stack.getStack(), state);
        stack.markDirty();
    }

    private static void setToggle(ItemStack stack, boolean state) {
        ArcaneGemItem gem = (ArcaneGemItem)stack.func_77973_b();
        if (gem.hasToggleMode()) {
            NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack);
            nbt.func_74757_a("toggle", state);
            stack.func_77982_d(nbt);
        }
    }

    public static AvailableGemsHandler getAvailableGems(EntityPlayer player) {
        return new AvailableGemsHandler(player);
    }

    public static AvailableGemsHandler.HandedGemsHandler getHeldGem(EntityPlayer player, EnumHand hand) {
        return new AvailableGemsHandler.HandedGemsHandler(player, hand);
    }

    public static boolean getHasRivertear(EntityPlayer player) {
        boolean hasRivertear = false;
        AvailableGemsHandler availableGems = GemUtil.getAvailableGems(player);
        for (GemStack gem : availableGems) {
            if (gem.getItem() != ItemRegistry.RIVERTEAR) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != ItemRegistry.RIVERTEAR) continue;
            return true;
        }
        return false;
    }

    public static class GemStack {
        private ItemStack stack;
        private AvailableGemsHandler handler;
        private boolean bauble = false;

        public ItemStack getStack() {
            return this.stack;
        }

        public AvailableGemsHandler getHandler() {
            return this.handler;
        }

        public Item getItem() {
            return this.stack.func_77973_b();
        }

        public ArcaneGemItem getArcaneGemItem() {
            return (ArcaneGemItem)this.stack.func_77973_b();
        }

        public GemStack(AvailableGemsHandler handler, ItemStack stack) {
            this.stack = stack;
            this.handler = handler;
        }

        public GemStack(AvailableGemsHandler handler, ItemStack stack, boolean bauble) {
            this(handler, stack);
            this.bauble = bauble;
        }

        public void markDirty() {
            if (this.bauble) {
                this.handler.markDirty();
            }
        }

        public boolean hasHandler() {
            return this.bauble;
        }
    }

    public static class AvailableGemsHandler
    implements Iterable<GemStack> {
        protected EntityPlayer player;
        protected GemSocketHandler handler = null;
        protected List<GemStack> gems = null;
        protected EnumHand hand;
        protected int baubleSlot = -1;

        public AvailableGemsHandler(EntityPlayer player) {
            this(player, EnumHand.MAIN_HAND);
        }

        public AvailableGemsHandler(EntityPlayer player, EnumHand hand) {
            this.player = player;
            this.hand = hand;
            this.getAvailableGems();
        }

        public void markDirty() {
            this.handler.saveToStack();
            if (Loader.isModLoaded((String)"baubles")) {
                BaubleGemUtil.markDirty(this.player, this.baubleSlot);
            }
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        protected List<GemStack> getAvailableGems() {
            if (this.gems == null || this.handler == null) {
                GemSocketHandler handler;
                this.gems = new ArrayList<GemStack>();
                if (this.player.func_184614_ca().func_77973_b() instanceof ArcaneGemItem) {
                    this.gems.add(new GemStack(this, this.player.func_184614_ca()));
                }
                if (this.player.func_184592_cb().func_77973_b() instanceof ArcaneGemItem) {
                    this.gems.add(new GemStack(this, this.player.func_184592_cb()));
                }
                if (this.player.field_71070_bA instanceof ContainerGemSocket) {
                    ContainerGemSocket container = (ContainerGemSocket)this.player.field_71070_bA;
                    Slot slot = container.func_75139_a(37);
                    if (slot.func_75216_d() && slot.func_75211_c().func_77973_b() instanceof ArcaneGemItem) {
                        this.gems.add(new GemStack(this, slot.func_75211_c()));
                    }
                } else if (Loader.isModLoaded((String)"baubles") && (handler = BaubleGemUtil.getSocket(this.player)) != null) {
                    this.handler = handler;
                    this.baubleSlot = handler.getBaubleSlot();
                    this.gems.add(new GemStack(this, handler.getGem(), true));
                }
            }
            return this.gems;
        }

        public GemStack getHeld() {
            return null;
        }

        @Override
        public Iterator<GemStack> iterator() {
            return this.getAvailableGems().iterator();
        }

        public int size() {
            return this.getAvailableGems().size();
        }

        public boolean isEmpty() {
            return this.getAvailableGems().isEmpty();
        }

        public GemStack get(int index) {
            return this.getAvailableGems().get(index);
        }

        public static class HandedGemsHandler
        extends AvailableGemsHandler {
            public HandedGemsHandler(EntityPlayer player, EnumHand hand) {
                super(player, hand);
            }

            @Override
            protected List<GemStack> getAvailableGems() {
                if (this.gems == null || this.handler == null) {
                    this.gems = new ArrayList();
                    if (this.player.func_184586_b(this.hand).func_77973_b() instanceof ArcaneGemItem) {
                        this.gems.add(new GemStack(this, this.player.func_184586_b(this.hand)));
                    }
                }
                return this.gems;
            }

            @Override
            public GemStack getHeld() {
                return this.getAvailableGems().get(0);
            }
        }
    }
}

