/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems;

import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.templates.ItemTemplate;
import com.aranaira.arcanearchives.util.ItemUtils;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GemRechargePowder
extends ItemTemplate {
    public static final String NAME = "chromatic_powder";

    public GemRechargePowder() {
        super(NAME);
        this.func_77637_a(null);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String key = "arcanearchives.tooltip." + this.func_77667_c(stack);
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)key, (Object[])new Object[0]));
        tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"arcanearchives.tooltip.creativeonly", (Object[])new Object[0]));
    }

    @Override
    public void registerModels() {
        ModelResourceLocation r = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.RED);
        ModelResourceLocation o = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.ORANGE);
        ModelResourceLocation y = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.YELLOW);
        ModelResourceLocation g = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.GREEN);
        ModelResourceLocation c = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.CYAN);
        ModelResourceLocation b = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.BLUE);
        ModelResourceLocation v = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.PURPLE);
        ModelResourceLocation p = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.PINK);
        ModelResourceLocation w = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.WHITE);
        ModelResourceLocation k = this.getColorizedPowderResourceLocation(ArcaneGemItem.GemColor.BLACK);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{w, r, o, y, g, c, b, v, p, k});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            ArcaneGemItem.GemColor color = GemRechargePowder.getColor(stack);
            switch (color) {
                case RED: {
                    return r;
                }
                case ORANGE: {
                    return o;
                }
                case YELLOW: {
                    return y;
                }
                case GREEN: {
                    return g;
                }
                case CYAN: {
                    return c;
                }
                case BLUE: {
                    return b;
                }
                case PURPLE: {
                    return v;
                }
                case PINK: {
                    return p;
                }
                case BLACK: {
                    return k;
                }
            }
            return w;
        });
    }

    public static ArcaneGemItem.GemColor getColor(ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getOrCreateTagCompound(stack);
        if (tag.func_74764_b("color")) {
            return ArcaneGemItem.GemColor.fromOrdinal(tag.func_74762_e("color"));
        }
        return ArcaneGemItem.GemColor.NOCOLOR;
    }

    protected ModelResourceLocation getColorizedPowderResourceLocation(ArcaneGemItem.GemColor color) {
        String loc = "arcanearchives:gems/powder/";
        loc = loc + color.toString().toLowerCase();
        return new ModelResourceLocation(loc, "inventory");
    }

    public String func_77667_c(ItemStack stack) {
        switch (GemRechargePowder.getColor(stack)) {
            case RED: {
                return "item.chromatic_powder.red";
            }
            case ORANGE: {
                return "item.chromatic_powder.orange";
            }
            case YELLOW: {
                return "item.chromatic_powder.yellow";
            }
            case GREEN: {
                return "item.chromatic_powder.green";
            }
            case CYAN: {
                return "item.chromatic_powder.cyan";
            }
            case BLUE: {
                return "item.chromatic_powder.blue";
            }
            case PURPLE: {
                return "item.chromatic_powder.purple";
            }
            case PINK: {
                return "item.chromatic_powder.pink";
            }
            case BLACK: {
                return "item.chromatic_powder.black";
            }
            case WHITE: {
                return "item.chromatic_powder.white";
            }
        }
        return super.func_77667_c(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (ArcaneGemItem.GemColor c : ArcaneGemItem.GemColor.values()) {
                if (c == ArcaneGemItem.GemColor.NOCOLOR) continue;
                ItemStack powder = new ItemStack((Item)this);
                NBTTagCompound tag = ItemUtils.getOrCreateTagCompound(powder);
                tag.func_74768_a("color", c.ordinal());
                subItems.add((Object)powder);
            }
        }
    }
}

