/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems;

import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.items.gems.GemRechargePowder;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.items.templates.ItemTemplate;
import java.awt.Color;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class ArcaneGemItem
extends ItemTemplate {
    public GemCut cut;
    public GemColor color;
    public int maxChargeNormal;
    public int maxChargeUpgraded;
    public static final byte UPGRADE_MATTER = 1;
    public static final byte UPGRADE_POWER = 2;
    public static final byte UPGRADE_SPACE = 4;
    public static final byte UPGRADE_TIME = 8;

    public ArcaneGemItem(String name, GemCut cut, GemColor color, int maxChargeNormal, int maxChargeUpgraded) {
        super(name);
        this.cut = cut;
        this.color = color;
        this.maxChargeNormal = maxChargeNormal;
        this.maxChargeUpgraded = maxChargeUpgraded;
        this.func_77625_d(1);
        if (!ConfigHandler.ArsenalConfig.EnableArsenal) {
            this.func_77637_a(null);
        }
        this.func_185043_a(new ResourceLocation("arcanearchives", "colourblind"), (stack, worldIn, entityIn) -> ConfigHandler.ArsenalConfig.ColourblindMode ? 1.0f : 0.0f);
    }

    public GemCut getGemCut() {
        return this.cut;
    }

    public GemColor getGemColor() {
        return this.color;
    }

    public int getMaxChargeNormal() {
        return this.maxChargeNormal;
    }

    public int getMaxChargeUpgraded() {
        return this.maxChargeUpgraded;
    }

    protected String getTooltipData(ItemStack stack) {
        String str = "";
        if (this.hasToggleMode()) {
            str = GemUtil.isToggledOn(stack) ? str + "[On] " : str + "[Off] ";
        }
        str = GemUtil.hasUnlimitedCharge(stack) ? str + "[Unlimited]" : str + "[" + GemUtil.getTooltipCharge(stack) + " / " + GemUtil.getTooltipMaxCharge(stack) + "]";
        byte upgrades = GemUtil.getUpgrades(stack);
        if ((upgrades & 1) == 1) {
            str = str + "   " + TextFormatting.GREEN + I18n.func_135052_a((String)"arcanearchives.tooltip.gemupgrade.matter", (Object[])new Object[0]);
        }
        if ((upgrades & 2) == 2) {
            str = str + "   " + TextFormatting.RED + I18n.func_135052_a((String)"arcanearchives.tooltip.gemupgrade.power", (Object[])new Object[0]);
        }
        if ((upgrades & 4) == 4) {
            str = str + "   " + TextFormatting.BLUE + I18n.func_135052_a((String)"arcanearchives.tooltip.gemupgrade.space", (Object[])new Object[0]);
        }
        if ((upgrades & 8) == 8) {
            str = str + "   " + TextFormatting.RED + I18n.func_135052_a((String)"arcanearchives.tooltip.gemupgrade.time", (Object[])new Object[0]);
        }
        return str;
    }

    public boolean hasToggleMode() {
        return false;
    }

    protected ModelResourceLocation getDunGemResourceLocation(GemCut cut) {
        String loc = "arcanearchives:gems/";
        loc = loc + cut.toString().toLowerCase() + "/dun";
        return new ModelResourceLocation(loc, "inventory");
    }

    protected ModelResourceLocation getConflictGemResourceLocation(GemCut cut) {
        String loc = "arcanearchives:gems/";
        loc = loc + cut.toString().toLowerCase() + "/static";
        return new ModelResourceLocation(loc, "inventory");
    }

    protected ModelResourceLocation getChargedGemResourceLocation(GemCut cut, GemColor color) {
        String loc = "arcanearchives:gems/";
        loc = loc + cut.toString().toLowerCase() + "/";
        loc = loc + color.toString().toLowerCase();
        return new ModelResourceLocation(loc, "inventory");
    }

    @Override
    public void registerModels() {
        ModelResourceLocation charged = this.getChargedGemResourceLocation(this.cut, this.color);
        ModelResourceLocation conflict = this.getConflictGemResourceLocation(this.cut);
        ModelResourceLocation dun = this.getDunGemResourceLocation(this.cut);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{charged, dun});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            if (GemUtil.isChargeEmpty(stack)) {
                return dun;
            }
            return charged;
        });
    }

    public static Vec3d blockPosToVector(BlockPos pos, boolean shiftToCenter) {
        if (shiftToCenter) {
            return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
        return new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public boolean recharge(World world, EntityPlayer player, GemUtil.GemStack gem) {
        return this.tryRechargingWithPowder(world, player, gem);
    }

    protected boolean tryRechargingWithPowder(World world, EntityPlayer player, GemUtil.GemStack gem) {
        IItemHandler cap = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        int fscp = -1;
        boolean recharged = false;
        for (int i = 0; i < cap.getSlots(); ++i) {
            if (cap.getStackInSlot(i).func_77973_b() == ItemRegistry.RAINBOW_CHROMATIC_POWDER) {
                fscp = i;
            }
            if (cap.getStackInSlot(i).func_77973_b() != ItemRegistry.CHROMATIC_POWDER || GemRechargePowder.getColor(cap.getStackInSlot(i)) != gem.getArcaneGemItem().getGemColor()) continue;
            this.informPlayerOfItemConsumption(player, gem, cap.getStackInSlot(i), 1);
            cap.getStackInSlot(i).func_190918_g(1);
            GemUtil.restoreCharge(gem, -1);
            recharged = true;
            break;
        }
        if (fscp > -1 && !recharged) {
            this.informPlayerOfItemConsumption(player, gem, cap.getStackInSlot(fscp), 1);
            cap.getStackInSlot(fscp).func_190918_g(1);
            GemUtil.restoreCharge(gem, -1);
            recharged = true;
        }
        return recharged;
    }

    protected void informPlayerOfItemConsumption(EntityPlayer player, ArcaneGemItem gem, ItemStack item, int quantity) {
        String quantityString = "";
        if (quantity > 1) {
            quantityString = " x" + quantity;
        }
        ITextComponent message = new TextComponentTranslation("arcanearchives.message.usedtorecharge", new Object[]{new TextComponentTranslation(item.func_77977_a() + ".name", new Object[0]), quantityString, new TextComponentTranslation(gem.func_77658_a() + ".name", new Object[0])}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD).func_150227_a(Boolean.valueOf(true)));
        player.func_146105_b(message, true);
    }

    protected void informPlayerOfItemConsumption(EntityPlayer player, GemUtil.GemStack gem, ItemStack item, int quantity) {
        this.informPlayerOfItemConsumption(player, gem.getArcaneGemItem(), item, quantity);
    }

    protected void consumeInventoryItemForChargeRecovery(EntityPlayer player, GemUtil.AvailableGemsHandler handler, Item targetItem, int needed, int maxCharge) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_77973_b() != targetItem) continue;
            int numConsumed = needed;
            if (numConsumed > stack.func_190916_E()) {
                numConsumed = stack.func_190916_E();
            }
            GemUtil.restoreCharge(handler.getHeld(), (int)Math.ceil((float)maxCharge * ((float)numConsumed / (float)needed)));
            stack.func_190918_g(numConsumed);
            break;
        }
    }

    protected void consumeFluidForChargeRecovery(EntityPlayer player, GemUtil.AvailableGemsHandler handler, Fluid targetFluid, int needed, int maxCharge) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            IFluidHandler cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (cap.drain(1000, false).getFluid() != targetFluid) continue;
            int numConsumed = cap.drain((int)1000, (boolean)true).amount;
            if (numConsumed > stack.func_190916_E()) {
                numConsumed = stack.func_190916_E();
            }
            GemUtil.restoreCharge(handler.getHeld(), (int)Math.ceil((float)maxCharge * ((float)numConsumed / (float)needed)));
            stack.func_190918_g(numConsumed);
            break;
        }
    }

    public static enum GemUpgrades {
        MATTER,
        POWER,
        SPACE,
        TIME;

    }

    public static enum GemColor {
        NOCOLOR,
        RED,
        ORANGE,
        YELLOW,
        GREEN,
        CYAN,
        BLUE,
        PURPLE,
        PINK,
        BLACK,
        WHITE;


        public static byte ToByte(GemColor color) {
            if (color == RED) {
                return 1;
            }
            if (color == ORANGE) {
                return 2;
            }
            if (color == YELLOW) {
                return 3;
            }
            if (color == GREEN) {
                return 4;
            }
            if (color == CYAN) {
                return 5;
            }
            if (color == BLUE) {
                return 6;
            }
            if (color == PURPLE) {
                return 7;
            }
            if (color == PINK) {
                return 8;
            }
            if (color == BLACK) {
                return 9;
            }
            if (color == WHITE) {
                return 10;
            }
            return 0;
        }

        public static GemColor fromByte(byte query) {
            if (query == 1) {
                return RED;
            }
            if (query == 2) {
                return ORANGE;
            }
            if (query == 3) {
                return YELLOW;
            }
            if (query == 4) {
                return GREEN;
            }
            if (query == 5) {
                return CYAN;
            }
            if (query == 6) {
                return BLUE;
            }
            if (query == 7) {
                return PURPLE;
            }
            if (query == 8) {
                return PINK;
            }
            if (query == 9) {
                return BLACK;
            }
            if (query == 10) {
                return WHITE;
            }
            return NOCOLOR;
        }

        public static Color getColor(GemColor color) {
            if (color == RED) {
                return new Color(1.0f, 0.5f, 0.5f, 1.0f);
            }
            if (color == ORANGE) {
                return new Color(1.0f, 0.75f, 0.5f, 1.0f);
            }
            if (color == YELLOW) {
                return new Color(1.0f, 1.0f, 0.5f, 1.0f);
            }
            if (color == GREEN) {
                return new Color(0.5f, 1.0f, 0.6f, 1.0f);
            }
            if (color == CYAN) {
                return new Color(0.5f, 1.0f, 1.0f, 1.0f);
            }
            if (color == BLUE) {
                return new Color(0.5f, 0.65f, 1.0f, 1.0f);
            }
            if (color == PURPLE) {
                return new Color(0.8f, 0.5f, 1.0f, 1.0f);
            }
            if (color == PINK) {
                return new Color(1.0f, 0.55f, 1.0f, 1.0f);
            }
            if (color == BLACK) {
                return new Color(0.0f, 0.0f, 0.0f, 1.0f);
            }
            return new Color(1, 1, 1, 1);
        }

        public static GemColor fromOrdinal(int ordinal) {
            int i = 0;
            for (GemColor c : GemColor.values()) {
                if (i == ordinal) {
                    return c;
                }
                ++i;
            }
            return NOCOLOR;
        }
    }

    public class GemWrapper {
        public ItemStack gem;
        public boolean inSocket;

        public GemWrapper(ItemStack gem, boolean inSocket) {
            this.gem = gem;
            this.inSocket = inSocket;
        }
    }

    public static enum GemCut {
        NOCUT,
        ASSCHER,
        OVAL,
        PAMPEL,
        PENDELOQUE,
        TRILLION;


        public static byte ToByte(GemCut cut) {
            if (cut == ASSCHER) {
                return 1;
            }
            if (cut == OVAL) {
                return 2;
            }
            if (cut == PAMPEL) {
                return 3;
            }
            if (cut == PENDELOQUE) {
                return 4;
            }
            if (cut == TRILLION) {
                return 5;
            }
            return 0;
        }

        public static GemCut fromByte(byte query) {
            if (query == 1) {
                return ASSCHER;
            }
            if (query == 2) {
                return OVAL;
            }
            if (query == 3) {
                return PAMPEL;
            }
            if (query == 4) {
                return PENDELOQUE;
            }
            if (query == 5) {
                return TRILLION;
            }
            return NOCUT;
        }
    }
}

