/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.items.DispenseAmphora;
import com.aranaira.arcanearchives.items.templates.ItemTemplate;
import com.aranaira.arcanearchives.tileentities.RadiantTankTileEntity;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RadiantAmphoraItem
extends ItemTemplate {
    public static final String NAME = "radiant_amphora";

    public RadiantAmphoraItem() {
        super(NAME);
        this.func_77625_d(1);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DispenseAmphora.getInstance());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidTankWrapper(new AmphoraUtil(stack));
    }

    @Override
    public void registerModels() {
        ModelResourceLocation unlinked = new ModelResourceLocation(this.getRegistryName() + "_unlinked", "inventory");
        ModelResourceLocation empty = new ModelResourceLocation(this.getRegistryName() + "_empty", "inventory");
        ModelResourceLocation fill = new ModelResourceLocation(this.getRegistryName() + "_fill", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{unlinked, empty, fill});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            AmphoraUtil util = new AmphoraUtil(stack);
            if (!util.isLinked()) {
                return unlinked;
            }
            if (util.getMode() == TankMode.DRAIN) {
                return empty;
            }
            return fill;
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.item.radiant_amphora", (Object[])new Object[0]));
        AmphoraUtil util = new AmphoraUtil(stack);
        if (util.isLinked()) {
            String dimensionType;
            BlockPos bp = util.getHomePos();
            int dimID = util.getHomeDim();
            String fluidType = util.getFluidType();
            tooltip.add("");
            try {
                dimensionType = DimensionType.func_186069_a((int)dimID).func_186065_b();
            }
            catch (IllegalArgumentException e) {
                dimensionType = "unknown dimension";
            }
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.amphora.linked", (Object[])new Object[]{bp.func_177958_n(), bp.func_177956_o(), bp.func_177952_p(), dimensionType, fluidType}));
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (state.func_177230_c() == BlockRegistry.RADIANT_TANK && stack.func_77973_b() == this && player.func_70093_af()) {
            AmphoraUtil util = new AmphoraUtil(stack);
            util.setHome(pos, world.field_73011_w.getDimension());
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        BlockPos targetPos;
        ItemStack itemstack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
        }
        AmphoraUtil util = new AmphoraUtil(itemstack);
        if (util.getMode() == TankMode.FILL) {
            RayTraceResult mop = this.func_77621_a(world, player, true);
            ActionResult result = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)itemstack, (RayTraceResult)mop);
            if (result == null) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
            }
            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            return result;
        }
        RayTraceResult mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
        }
        IFluidHandler cap = util.getCapability();
        if (cap == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
        }
        boolean canDrain = false;
        for (IFluidTankProperties prop : cap.getTankProperties()) {
            if (prop.getCapacity() < 1000) continue;
            canDrain = true;
            break;
        }
        if (!canDrain) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
        }
        FluidStack fluidStack = util.getFluidStack(cap);
        BlockPos clickPos = mop.func_178782_a();
        if (world.func_175660_a(player, clickPos) && player.func_175151_a(targetPos = clickPos.func_177972_a(mop.field_178784_b), mop.field_178784_b, itemstack)) {
            if (!world.field_72995_K) {
                FluidActionResult result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)targetPos, (ItemStack)itemstack, (FluidStack)fluidStack);
                if (result.isSuccess()) {
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemstack);
                }
            } else {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (event.getEmptyBucket().func_77973_b() != this) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        ItemStack amphora = event.getEmptyBucket();
        AmphoraUtil util = new AmphoraUtil(amphora);
        if (util.getMode() != TankMode.FILL) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = target.func_178782_a();
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)amphora, (EntityPlayer)event.getEntityPlayer(), (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        if (filledResult.isSuccess()) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(filledResult.getResult());
        } else {
            event.setCanceled(true);
        }
    }

    public static enum TankMode {
        DRAIN,
        FILL;


        public static TankMode fromOrdinal(int ordinal) {
            if (ordinal == 0) {
                return DRAIN;
            }
            return FILL;
        }
    }

    private static class FluidTankWrapper
    implements IFluidHandlerItem,
    ICapabilityProvider {
        private static long VALIDITY_DELAY = 5000L;
        protected AmphoraUtil util;

        public FluidTankWrapper(AmphoraUtil util) {
            this.util = util;
        }

        public IFluidTankProperties[] getTankProperties() {
            IFluidHandler tank = this.util.getCapability();
            if (tank == null) {
                return new IFluidTankProperties[0];
            }
            return tank.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            IFluidHandler tank = this.util.getCapability();
            if (tank == null) {
                return 0;
            }
            return tank.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            IFluidHandler tank = this.util.getCapability();
            if (tank == null) {
                return null;
            }
            return tank.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            IFluidHandler tank = this.util.getCapability();
            if (tank == null) {
                return null;
            }
            return tank.drain(maxDrain, doDrain);
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.util.getStack();
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return (T)new FluidTankWrapper(this.util);
            }
            return null;
        }
    }

    public static class AmphoraUtil {
        private ItemStack stack;

        public AmphoraUtil(ItemStack incoming) {
            if (incoming.func_190926_b()) {
                incoming = new ItemStack((Item)ItemRegistry.RADIANT_AMPHORA);
            }
            this.stack = incoming;
            ItemUtils.getOrCreateTagCompound(this.stack);
        }

        @Nullable
        public World getWorld() {
            return this.getWorld(0);
        }

        @Nullable
        public World getWorld(int dimension) {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            if (side == Side.CLIENT) {
                try {
                    return this.getClientWorld();
                }
                catch (NoClassDefFoundError e) {
                    ArcaneArchives.logger.error("[Amphora] Was told we were on the client but client-side method results in Minecraft 'class not found' error. How could this happen!", (Throwable)new IllegalArgumentException());
                    return null;
                }
            }
            return this.getServerWorld(dimension);
        }

        @SideOnly(value=Side.CLIENT)
        private World getClientWorld() {
            return Minecraft.func_71410_x().field_71441_e;
        }

        private World getServerWorld(int dimension) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            return server.func_71218_a(dimension);
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public NBTTagCompound getTag() {
            return this.stack.func_77978_p();
        }

        public boolean isRemote() {
            RadiantTankTileEntity te = this.getTile();
            if (te == null) {
                return true;
            }
            return te.func_145831_w().field_72995_K;
        }

        public void setHome(BlockPos pos, int dimension) {
            this.getTag().func_74772_a("homeTank", pos.func_177986_g());
            this.getTag().func_74768_a("homeTankDim", dimension);
        }

        public BlockPos getHomePos() {
            if (!this.getTag().func_74764_b("homeTank")) {
                return null;
            }
            return BlockPos.func_177969_a((long)this.getTag().func_74763_f("homeTank"));
        }

        public int getHomeDim() {
            return this.getTag().func_74762_e("homeTankDim");
        }

        public TankMode getMode() {
            if (!this.getTag().func_74764_b("mode")) {
                this.getTag().func_74768_a("mode", TankMode.FILL.ordinal());
            }
            return TankMode.fromOrdinal(this.getTag().func_74762_e("mode"));
        }

        public void setMode(TankMode mode) {
            if (this.getTag() != null) {
                this.getTag().func_74768_a("mode", mode.ordinal());
            }
        }

        public void toggleMode() {
            if (!this.getTag().func_74764_b("mode")) {
                this.getTag().func_74768_a("mode", TankMode.FILL.ordinal());
            } else {
                TankMode current = TankMode.fromOrdinal(this.getTag().func_74762_e("mode"));
                if (current == TankMode.FILL) {
                    this.getTag().func_74768_a("mode", TankMode.DRAIN.ordinal());
                } else {
                    this.getTag().func_74768_a("mode", TankMode.FILL.ordinal());
                }
            }
        }

        public boolean isLinked() {
            return this.getTag().func_74764_b("homeTank") && this.getTag().func_74764_b("homeTankDim");
        }

        @SideOnly(value=Side.CLIENT)
        public String getFluidType() {
            IFluidHandler handler = this.getCapability();
            if (handler != null) {
                FluidStack stack = this.getFluidStack(handler);
                Fluid fluid = this.getFluid(handler);
                if (stack == null && fluid == null) {
                    return "Unknown fluid";
                }
                if (net.minecraft.util.text.translation.I18n.func_94522_b((String)stack.getFluid().getName())) {
                    return net.minecraft.util.text.translation.I18n.func_74838_a((String)stack.getFluid().getName());
                }
                if (stack == null) {
                    return "Unknown fluid";
                }
                return net.minecraft.util.text.translation.I18n.func_74837_a((String)stack.getLocalizedName(), (Object[])new Object[0]);
            }
            return "Unknown fluid";
        }

        @Nullable
        public Fluid getFluid() {
            IFluidHandler cap = this.getCapability();
            if (cap == null) {
                return null;
            }
            return this.getFluid(cap);
        }

        @Nullable
        public Fluid getFluid(IFluidHandler capability) {
            if (capability == null) {
                return null;
            }
            IFluidTankProperties[] props = capability.getTankProperties();
            if (props.length == 0) {
                return null;
            }
            FluidStack contents = props[0].getContents();
            if (contents == null) {
                return null;
            }
            return contents.getFluid();
        }

        @Nullable
        public FluidStack getFluidStack(IFluidHandler capability) {
            Fluid fluid = this.getFluid(capability);
            if (fluid == null) {
                return null;
            }
            return new FluidStack(fluid, 1000);
        }

        @Nullable
        public RadiantTankTileEntity getTile() {
            if (this.getTag().func_74764_b("homeTank") && this.getTag().func_74764_b("homeTankDim")) {
                int dim = this.getTag().func_74762_e("homeTankDim");
                World world = this.getWorld(dim);
                BlockPos home = BlockPos.func_177969_a((long)this.getTag().func_74763_f("homeTank"));
                if (world != null && world.field_73011_w.getDimension() == dim) {
                    return WorldUtil.getTileEntity(RadiantTankTileEntity.class, (IBlockAccess)world, home);
                }
            }
            return null;
        }

        @Nullable
        public IFluidHandler getCapability() {
            if (this.getTag() == null || this.getTag().func_82582_d()) {
                return null;
            }
            RadiantTankTileEntity te = this.getTile();
            if (te == null) {
                return null;
            }
            IFluidHandler capability = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (capability == null) {
                return null;
            }
            return capability;
        }

        public boolean valid() {
            return this.getCapability() != null;
        }
    }
}

