/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.client.Keybinds;
import com.aranaira.arcanearchives.data.ClientNetwork;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.items.templates.ItemTemplate;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ManifestItem
extends ItemTemplate {
    public static final String NAME = "manifest";

    public ManifestItem() {
        super(NAME);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        ManifestItem.openManifest(worldIn, playerIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public static void openManifest(World worldIn, EntityPlayer playerIn) {
        if (playerIn.func_70093_af()) {
            ManifestTrackingUtils.clear();
        } else {
            ClientNetwork network = DataHelper.getClientNetwork(playerIn.func_110124_au());
            network.manifestItems.clear();
            network.synchroniseManifest();
            playerIn.openGui((Object)ArcaneArchives.instance, 2, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.item.manifest", (Object[])new Object[0]));
        String additional = "";
        if (Keybinds.manifestKey.func_151463_i() != 0) {
            additional = " or " + Keybinds.manifestKey.getDisplayName();
        }
        tooltip.add(TextFormatting.GOLD + "" + TextFormatting.BOLD + "Right-Click" + additional + TextFormatting.RESET + TextFormatting.GOLD + " to open the manifest.");
        if (Keybinds.manifestKey.func_151463_i() != 0) {
            additional = " or Sneak-" + Keybinds.manifestKey.getDisplayName();
        }
        tooltip.add(TextFormatting.GOLD + "" + TextFormatting.BOLD + "Sneak-Right-Click" + additional + TextFormatting.RESET + TextFormatting.GOLD + " to clear inventory tracking.");
        if (Keybinds.manifestKey.func_151463_i() == 0) {
            // empty if block
        }
    }
}

