/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items;

import com.aranaira.arcanearchives.items.RadiantAmphoraItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DispenseAmphora
implements IBehaviorDispenseItem {
    private static final DispenseAmphora INSTANCE = new DispenseAmphora();

    public static DispenseAmphora getInstance() {
        return INSTANCE;
    }

    private DispenseAmphora() {
    }

    private void success(IBlockSource source) {
        this.playDispenseSound(source);
        this.spawnDispenseParticles(source, (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
    }

    public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
        World world = source.func_82618_k();
        EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos target = source.func_180699_d().func_177972_a(facing);
        IBlockState targetState = world.func_180495_p(target);
        Block targetBlock = targetState.func_177230_c();
        RadiantAmphoraItem.AmphoraUtil util = new RadiantAmphoraItem.AmphoraUtil(stack);
        RadiantAmphoraItem.TankMode originalMode = util.getMode();
        if (targetState.func_177230_c().func_176200_f((IBlockAccess)world, target) && !(targetBlock instanceof BlockLiquid) && !(targetBlock instanceof IFluidBlock)) {
            IFluidHandler cap = util.getCapability();
            if (cap == null) {
                return stack;
            }
            FluidStack output = util.getFluidStack(cap);
            if (output == null) {
                return stack;
            }
            util.setMode(RadiantAmphoraItem.TankMode.DRAIN);
            FluidActionResult result = FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)target, (ItemStack)stack, (FluidStack)output);
            util.setMode(originalMode);
            if (result.isSuccess()) {
                this.success(source);
                return result.getResult();
            }
            return stack;
        }
        util.setMode(RadiantAmphoraItem.TankMode.FILL);
        FluidActionResult actionResult = FluidUtil.tryPickUpFluid((ItemStack)stack, null, (World)world, (BlockPos)target, (EnumFacing)facing.func_176734_d());
        util.setMode(originalMode);
        this.success(source);
        if (actionResult.isSuccess()) {
            return actionResult.getResult();
        }
        return stack;
    }

    protected void playDispenseSound(IBlockSource source) {
        source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
    }

    protected void spawnDispenseParticles(IBlockSource source, EnumFacing facingIn) {
        source.func_82618_k().func_175718_b(2000, source.func_180699_d(), this.getWorldEventDataFrom(facingIn));
    }

    private int getWorldEventDataFrom(EnumFacing facingIn) {
        return facingIn.func_82601_c() + 1 + (facingIn.func_82599_e() + 1) * 3;
    }
}

