/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory.handlers;

import com.aranaira.arcanearchives.inventory.handlers.ITroveItemHandler;
import com.aranaira.arcanearchives.inventory.handlers.OptionalUpgradesHandler;
import com.aranaira.arcanearchives.inventory.handlers.TroveUpgradeItemHandler;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import com.aranaira.arcanearchives.types.enums.UpgradeType;
import com.aranaira.arcanearchives.util.ItemUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;

public class TroveItemBlockItemHandler
implements ITroveItemHandler,
ICapabilityProvider {
    private TroveUpgradeItemHandler upgrades = null;
    private OptionalUpgradesHandler optionals = null;
    private ItemStack container;
    private static int BASE_COUNT = RadiantTroveTileEntity.BASE_COUNT;
    private int count = -1;
    private ItemStack reference = null;

    public TroveItemBlockItemHandler(ItemStack container) {
        this.container = container;
    }

    public int getUpgrades() {
        if (this.upgrades == null) {
            NBTTagCompound tag = this.container.func_77978_p();
            if (tag == null || !tag.func_74764_b("size_upgrades")) {
                return 0;
            }
            this.upgrades = new TroveUpgradeItemHandler();
            this.upgrades.deserializeNBT(tag.func_74775_l("size_upgrades"));
        }
        return this.upgrades.getUpgradesCount();
    }

    public int getSlots() {
        return 2;
    }

    @Override
    public int getSlotLimit(int slot) {
        return (this.getUpgrades() + 1) * BASE_COUNT;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    @Override
    public ItemStack getReference() {
        if (this.reference == null) {
            NBTTagCompound tag = this.container.func_77978_p();
            if (tag == null || !tag.func_74764_b("handler_item")) {
                return ItemStack.field_190927_a;
            }
            NBTTagCompound incoming = tag.func_74775_l("handler_item");
            this.reference = new ItemStack(incoming.func_74775_l("REFERENCE"));
        }
        return this.reference;
    }

    @Override
    public int getCount() {
        if (this.count == -1) {
            NBTTagCompound tag = this.container.func_77978_p();
            if (tag == null || !tag.func_74764_b("handler_item")) {
                return 0;
            }
            NBTTagCompound incoming = tag.func_74775_l("handler_item");
            this.count = incoming.func_74762_e("COUNT");
        }
        return this.count;
    }

    @Override
    public int getMaxCount() {
        return (this.getUpgrades() + 1) * BASE_COUNT;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
        this.saveToStack();
    }

    private OptionalUpgradesHandler getOptionals() {
        if (this.optionals == null) {
            NBTTagCompound tag = this.container.func_77978_p();
            if (tag == null || !tag.func_74764_b("optional_upgrades")) {
                return null;
            }
            this.optionals = new OptionalUpgradesHandler();
            this.optionals.deserializeNBT(tag.func_74775_l("optional_upgrades"));
        }
        return this.optionals;
    }

    @Override
    public boolean isVoiding() {
        OptionalUpgradesHandler handler = this.getOptionals();
        if (handler == null) {
            return false;
        }
        return handler.hasUpgrade(UpgradeType.VOID);
    }

    @Override
    public boolean isLocked() {
        OptionalUpgradesHandler handler = this.getOptionals();
        if (handler == null) {
            return false;
        }
        return handler.hasUpgrade(UpgradeType.LOCK);
    }

    @Override
    public void update() {
        this.saveToStack();
    }

    @Override
    public ItemStack getItem() {
        return this.getReference();
    }

    @Override
    public ItemStack getItemCurrent() {
        if (this.getCount() == 0) {
            return ItemStack.field_190927_a;
        }
        return this.getReference();
    }

    @Override
    public void setReference(ItemStack reference) {
        this.reference = reference;
        this.saveToStack();
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() == 0 && this.getReference().func_190926_b();
    }

    public void saveToStack() {
        NBTTagCompound tag = ItemUtils.getOrCreateTagCompound(this.container);
        NBTTagCompound result = new NBTTagCompound();
        if (this.count != -1) {
            result.func_74768_a("COUNT", this.count);
        }
        if (this.reference != null) {
            result.func_74782_a("REFERENCE", (NBTBase)this.reference.serializeNBT());
        }
        if (this.upgrades != null) {
            result.func_74768_a("UPGRADES", this.getUpgrades());
        }
        tag.func_74782_a("handler_item", (NBTBase)result);
    }
}

