/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory.handlers;

import com.aranaira.arcanearchives.util.NBTUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class TankItemFluidHandler
extends FluidHandlerItemStack {
    @Nonnull
    protected ItemStack container;

    public TankItemFluidHandler(@Nonnull ItemStack container) {
        super(container, NBTUtils.defaultInt(container, "maximum_capacity", 16000));
        this.container = container;
    }

    public int getCapacity() {
        return NBTUtils.defaultInt(this.container, "maximum_capacity", 16000);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.getCapacity())};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount <= 0 || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained == null) {
            int fillAmount = Math.min(this.getCapacity(), resource.amount);
            if (doFill) {
                FluidStack filled = resource.copy();
                filled.amount = fillAmount;
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getCapacity() - contained.amount, resource.amount);
            if (doFill && fillAmount > 0) {
                contained.amount += fillAmount;
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }
}

