/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory.handlers;

import com.aranaira.arcanearchives.util.ItemUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public interface ITroveItemHandler
extends IItemHandler {
    public ItemStack getReference();

    public int getCount();

    public int getMaxCount();

    public void setCount(int var1);

    public boolean isVoiding();

    public boolean isLocked();

    public void update();

    public ItemStack getItem();

    public ItemStack getItemCurrent();

    public void setReference(ItemStack var1);

    public boolean isEmpty();

    default public int getSlotLimit(int slot) {
        return this.getMaxCount();
    }

    default public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return ItemUtils.areStacksEqualIgnoreSize(this.getReference(), stack);
    }

    @Nonnull
    default public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack reference = this.getReference();
        if (reference.func_190926_b()) {
            this.setReference(stack);
        }
        int count = this.getCount();
        if (ItemUtils.areStacksEqualIgnoreSize(reference, stack)) {
            int thisCount = stack.func_190916_E();
            int diff = 0;
            if (count + thisCount > this.getMaxCount()) {
                diff = count + thisCount - this.getMaxCount();
            }
            if (simulate) {
                if (diff == 0) {
                    return ItemStack.field_190927_a;
                }
                ItemStack result = stack.func_77946_l();
                result.func_190920_e(diff);
                if (this.isVoiding()) {
                    return ItemStack.field_190927_a;
                }
                return result;
            }
            if (diff != 0) {
                this.setCount(count + thisCount - diff);
                ItemStack result = stack.func_77946_l();
                result.func_190920_e(diff);
                this.update();
                if (this.isVoiding()) {
                    return ItemStack.field_190927_a;
                }
                return result;
            }
            this.setCount(count + stack.func_190916_E());
            this.update();
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Nonnull
    default public ItemStack getStackInSlot(int slot) {
        ItemStack reference = this.getReference();
        if (reference == null || reference.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (slot == 0) {
            ItemStack result = reference.func_77946_l();
            result.func_190920_e(this.getCount());
            return result;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result;
        ItemStack reference = this.getReference();
        if (reference == null || reference.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int count = this.getCount();
        if (amount > reference.func_77976_d()) {
            amount = reference.func_77976_d();
        }
        if (count < amount) {
            amount = count;
        }
        if (amount < (result = this.getStackInSlot(0)).func_190916_E()) {
            result.func_190920_e(amount);
        }
        if (simulate) {
            return result;
        }
        this.setCount(count - amount);
        this.update();
        return result;
    }
}

