/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory.handlers;

import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.items.gems.pendeloque.ParchtearItem;
import com.aranaira.arcanearchives.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.ItemStackHandler;

public class DevouringCharmHandler {
    private ItemStack socket;
    private ItemStackHandler autovoidHandler = new ItemStackHandler(6){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                super.setStackInSlot(slot, stack);
            } else {
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                super.setStackInSlot(slot, copy);
            }
            DevouringCharmHandler.this.saveToStack();
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            super.setStackInSlot(slot, ItemStack.field_190927_a);
            DevouringCharmHandler.this.saveToStack();
            return ItemStack.field_190927_a;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            throw new IllegalArgumentException("setStackInSlot is unusable");
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    };
    private ItemStackHandler handler = new ItemStackHandler(7){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || stack.func_77973_b() == ItemRegistry.PARCHTEAR;
            }
            return true;
        }

        protected void onContentsChanged(int slot) {
            IFluidTankProperties[] props;
            ItemStack stack = this.getStackInSlot(slot);
            IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (cap != null && (props = cap.getTankProperties()).length >= 1) {
                FluidStack drain = props[0].getContents();
                cap.drain(drain, true);
            }
            if (slot == 0 && stack.func_77973_b() == ItemRegistry.PARCHTEAR && stack.func_77973_b() instanceof ParchtearItem) {
                GemUtil.manuallyRestoreCharge(stack, -1);
            }
            super.onContentsChanged(slot);
        }
    };

    public DevouringCharmHandler(ItemStack socket) {
        this.socket = socket;
        NBTTagCompound tag = ItemUtils.getOrCreateTagCompound(socket);
        if (tag.func_74764_b("autovoid_handler")) {
            this.autovoidHandler.deserializeNBT(tag.func_74775_l("autovoid_handler"));
        }
    }

    public void saveToStack() {
        NBTTagCompound tag = ItemUtils.getOrCreateTagCompound(this.socket);
        tag.func_74782_a("autovoid_handler", (NBTBase)this.autovoidHandler.serializeNBT());
    }

    public ItemStackHandler getInventory() {
        return this.handler;
    }

    public ItemStackHandler getAutovoidInventory() {
        return this.autovoidHandler;
    }

    public List<ItemStack> getItemsToVoid() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            ItemStack item = this.autovoidHandler.getStackInSlot(i);
            if (item.func_190926_b()) continue;
            items.add(item);
        }
        return items;
    }

    public boolean shouldVoidItem(ItemStack stack) {
        for (ItemStack other : this.getItemsToVoid()) {
            if (!ItemUtils.areStacksEqualIgnoreSize(stack, other)) continue;
            return true;
        }
        return false;
    }

    public static DevouringCharmHandler getHandler(ItemStack stack) {
        DevouringCharmHandler handler = new DevouringCharmHandler(stack);
        return handler;
    }

    public static class Tags {
        public static final String AUTOVOID_HANDLER = "autovoid_handler";
    }
}

