/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory;

import com.aranaira.arcanearchives.inventory.handlers.OptionalUpgradesHandler;
import com.aranaira.arcanearchives.inventory.handlers.SizeUpgradeItemHandler;
import com.aranaira.arcanearchives.items.IUpgradeItem;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IUpgradeableStorage;
import com.aranaira.arcanearchives.types.enums.UpgradeType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerUpgrades
extends Container {
    private IUpgradeableStorage storage;
    private ImmanenceTileEntity tile;
    private EntityPlayer player;
    private SizeUpgradeItemHandler sizeHandler;
    private OptionalUpgradesHandler optionalHandler;

    public ContainerUpgrades(EntityPlayer player, ImmanenceTileEntity tile) {
        assert (tile instanceof IUpgradeableStorage);
        this.storage = (IUpgradeableStorage)((Object)tile);
        this.tile = tile;
        this.player = player;
        this.sizeHandler = this.storage.getSizeUpgradesHandler();
        this.optionalHandler = this.storage.getOptionalUpgradesHandler();
        this.createPlayerInventory(player.field_71071_by);
        this.createUpgradeInventory();
    }

    private void createUpgradeInventory() {
        int i;
        int xOffset = 57;
        int yOffset = 8;
        int xSpacing = 25;
        int ySpacing = 36;
        for (i = 0; i < 3; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.sizeHandler, i, xOffset + i * xSpacing, yOffset));
        }
        for (i = 0; i < 3; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.optionalHandler, i, xOffset + i * xSpacing, yOffset + ySpacing));
        }
    }

    private void createPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = 10;
        int yOffset = 80;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = this.func_75139_a(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            if (index < 36 && stack.func_77973_b() instanceof IUpgradeItem) {
                IUpgradeItem upgrade = (IUpgradeItem)stack.func_77973_b();
                int upgradeSlot = 36;
                if (upgrade.getUpgradeType(stack) == UpgradeType.SIZE) {
                    int upSlot = upgrade.getSlotIsUpgradeFor(stack);
                    Slot target = this.func_75139_a(upgradeSlot += upSlot);
                    switch (upSlot) {
                        case 0: {
                            if (target.func_75216_d() || this.func_75135_a(stack, upgradeSlot, upgradeSlot + 1, false)) break;
                            return ItemStack.field_190927_a;
                        }
                        case 1: {
                            if (!this.sizeHandler.hasUpgrade(0) || target.func_75216_d() || this.func_75135_a(stack, upgradeSlot, upgradeSlot + 1, false)) break;
                            return ItemStack.field_190927_a;
                        }
                        case 2: {
                            if (!this.sizeHandler.hasUpgrade(0) || !this.sizeHandler.hasUpgrade(1) || target.func_75216_d() || this.func_75135_a(stack, upgradeSlot, upgradeSlot + 1, false)) break;
                            return ItemStack.field_190927_a;
                        }
                    }
                } else {
                    upgradeSlot += 3;
                    UpgradeType type = upgrade.getUpgradeType(stack);
                    if (!this.optionalHandler.hasUpgrade(type)) {
                        Slot target = this.func_75139_a(upgradeSlot);
                        while (target != null && target.func_75216_d()) {
                            target = this.func_75139_a(++upgradeSlot);
                        }
                        if (target != null && this.func_75135_a(stack, upgradeSlot, upgradeSlot + 1, false)) {
                            return ItemStack.field_190927_a;
                        }
                    }
                }
                return ItemStack.field_190927_a;
            }
            if (index >= 36 && index < 39) {
                int upSlot = Math.max(index - 36, 0);
                if (!this.sizeHandler.extractItem(upSlot, 1, true).func_190926_b()) {
                    this.func_75135_a(stack, 0, 36, false);
                    this.sizeHandler.extractItem(upSlot, 1, false);
                }
            } else if (index >= 39 && index < 42 && !this.func_75135_a(stack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
        }
        return ItemStack.field_190927_a;
    }
}

