/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory;

import com.aranaira.arcanearchives.inventory.handlers.InventoryCraftingPersistent;
import com.aranaira.arcanearchives.inventory.slots.SlotCraftingFastWorkbench;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketRadiantCrafting;
import com.aranaira.arcanearchives.tileentities.RadiantCraftingTableTileEntity;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber
public class ContainerRadiantCraftingTable
extends Container {
    public static IInventory emptyInventory = new InventoryBasic("[Null]", true, 0);
    public final BlockPos pos;
    protected final World world;
    private final ItemStackHandler itemHandler;
    private final EntityPlayer player;
    private final InventoryCraftingPersistent craftMatrix;
    private final InventoryCraftResult craftResult;
    private IRecipe lastRecipe;
    private IRecipe lastLastRecipe;
    private List<SlotIRecipe> recipeSlots = Arrays.asList(new SlotIRecipe[3]);
    private IRecipe lastCraftedRecipe;
    public RadiantCraftingTableTileEntity tile;

    public IRecipe getLastCraftedRecipe() {
        return this.lastCraftedRecipe;
    }

    public IRecipe getCurrentRecipe() {
        return this.lastRecipe;
    }

    public ContainerRadiantCraftingTable(RadiantCraftingTableTileEntity tile, EntityPlayer player, InventoryPlayer playerInventory) {
        this.tile = tile;
        this.world = tile.func_145831_w();
        this.pos = tile.func_174877_v();
        this.itemHandler = tile.getInventory();
        this.craftResult = new InventoryCraftResult();
        this.craftMatrix = new InventoryCraftingPersistent((Container)this, this.itemHandler, tile, 3, 3);
        this.player = player;
        this.func_75146_a((Slot)new SlotCraftingFastWorkbench(this, playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 136, 42));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 3, 24 + j * 18, 24 + i * 18));
            }
        }
        int index = 9;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, index, 23 + col * 18, 115 + row * 18));
                ++index;
            }
        }
        index = 0;
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, index, 23 + col * 18, 173));
            ++index;
        }
        this.recipeSlots.set(0, new SlotIRecipe(this, 0, 174, 16));
        this.recipeSlots.set(1, new SlotIRecipe(this, 1, 174, 42));
        this.recipeSlots.set(2, new SlotIRecipe(this, 2, 174, 68));
        this.recipeSlots.forEach(arg_0 -> ((ContainerRadiantCraftingTable)this).func_75146_a(arg_0));
    }

    @SubscribeEvent
    public static void onCraftingStationGuiOpened(PlayerContainerEvent.Open event) {
        if (event.getContainer() instanceof ContainerRadiantCraftingTable) {
            ((ContainerRadiantCraftingTable)event.getContainer()).onCraftMatrixChanged();
        }
    }

    public void onCraftMatrixChanged() {
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public void saveLastRecipe() {
        this.lastCraftedRecipe = this.lastRecipe;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack original = slot.func_75211_c().func_77946_l();
        ItemStack itemstack = slot.func_75211_c().func_77946_l();
        int end = this.field_75151_b.size() - 3;
        if (index < 10 ? !this.func_75135_a(itemstack, 10, end, true) : !this.func_75135_a(itemstack, 0, 10, false)) {
            return ItemStack.field_190927_a;
        }
        slot.func_75218_e();
        if (itemstack.func_190916_E() == original.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_75215_d(itemstack);
        slot.func_190901_a(this.player, itemstack);
        if (slot.func_75216_d() && slot.func_75211_c().func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return original;
    }

    protected boolean mergeItemStackRefill(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = startIndex;
        if (useEndIndex) {
            k = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(k);
                ItemStack itemstack1 = slot.func_75211_c();
                if (!itemstack1.func_190926_b() && itemstack1.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack1) && this.func_94530_a(stack, slot)) {
                    int limit;
                    int l = itemstack1.func_190916_E() + stack.func_190916_E();
                    if (l <= (limit = Math.min(stack.func_77976_d(), slot.func_178170_b(stack)))) {
                        stack.func_190920_e(0);
                        itemstack1.func_190920_e(l);
                        slot.func_75218_e();
                        flag1 = true;
                    } else if (itemstack1.func_190916_E() < limit) {
                        stack.func_190918_g(limit - itemstack1.func_190916_E());
                        itemstack1.func_190920_e(limit);
                        slot.func_75218_e();
                        flag1 = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    protected boolean mergeItemStackMove(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            Slot slot = (Slot)this.field_75151_b.get(k);
            ItemStack itemstack1 = slot.func_75211_c();
            if (itemstack1.func_190926_b() && slot.func_75214_a(stack) && this.func_94530_a(stack, slot)) {
                int limit = slot.func_178170_b(stack);
                ItemStack stack2 = stack.func_77946_l();
                if (stack2.func_190916_E() > limit) {
                    stack2.func_190920_e(limit);
                    stack.func_190918_g(limit);
                } else {
                    stack.func_190920_e(0);
                }
                slot.func_75215_d(stack2);
                slot.func_75218_e();
                flag1 = true;
                if (stack.func_190926_b()) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return flag1;
    }

    public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
        return p_94530_2_.field_75224_c != this.craftResult && super.func_94530_a(p_94530_1_, p_94530_2_);
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.func_192389_a(this.world, this.player, this.craftMatrix, this.craftResult);
    }

    public void func_190896_a(List<ItemStack> p_190896_1_) {
        this.craftMatrix.setDoNotCallUpdates(true);
        super.func_190896_a(p_190896_1_);
        this.craftMatrix.setDoNotCallUpdates(false);
        this.craftMatrix.onCraftMatrixChanged();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    protected boolean func_75135_a(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (!stack.func_190926_b() && stack.func_190916_E() > 0) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting inv, InventoryCraftResult result) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (this.lastRecipe == null || !this.lastRecipe.func_77569_a(inv, world)) {
            this.lastRecipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)world);
        }
        if (this.lastRecipe != null) {
            itemstack = this.lastRecipe.func_77572_b(inv);
        }
        if (!world.field_72995_K) {
            result.func_70299_a(0, itemstack);
            EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
            entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, itemstack));
            Networking.CHANNEL.sendTo((IMessage)new PacketRadiantCrafting.LastRecipe(this.lastRecipe), entityplayermp);
        }
        this.lastLastRecipe = this.lastRecipe;
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftMatrix;
    }

    public void updateLastRecipeFromServer(IRecipe recipe) {
        ItemStack stack;
        if (this.lastRecipe == recipe) {
            return;
        }
        this.lastRecipe = recipe;
        if (recipe != null && recipe.func_77569_a((InventoryCrafting)this.craftMatrix, this.world) && !(stack = recipe.func_77572_b((InventoryCrafting)this.craftMatrix)).func_190926_b()) {
            this.craftResult.func_70299_a(0, stack);
        }
    }

    public NonNullList<ItemStack> getRemainingItems() {
        if (this.lastRecipe != null && this.lastRecipe.func_77569_a((InventoryCrafting)this.craftMatrix, this.world)) {
            return this.lastRecipe.func_179532_b((InventoryCrafting)this.craftMatrix);
        }
        return this.craftMatrix.field_70466_a;
    }

    public class SlotIRecipe
    extends Slot {
        private int recipe;

        public SlotIRecipe(ContainerRadiantCraftingTable container, int index, int xPosition, int yPosition) {
            super(emptyInventory, index, xPosition, yPosition);
            this.recipe = index;
        }

        public int getRecipe() {
            return this.recipe;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75211_c() {
            if (ContainerRadiantCraftingTable.this.tile.getRecipe(this.recipe) != null) {
                return ContainerRadiantCraftingTable.this.tile.getRecipe(this.recipe).func_77571_b();
            }
            return ItemStack.field_190927_a;
        }

        public void func_75215_d(ItemStack stack) {
        }

        public ItemStack func_75209_a(int amount) {
            return ItemStack.field_190927_a;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return false;
        }
    }
}

