/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.integration.top;

import com.aranaira.arcanearchives.blocks.RadiantChest;
import com.aranaira.arcanearchives.blocks.RadiantResonator;
import com.aranaira.arcanearchives.blocks.RadiantTrove;
import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantResonatorTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TOPPlugin
implements Function<ITheOneProbe, Void>,
IProbeInfoProvider {
    public String getID() {
        return "arcanearchives:top_integration";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        RadiantTroveTileEntity trove;
        Block block = blockState.func_177230_c();
        if (block instanceof RadiantChest) {
            String chestName;
            RadiantChestTileEntity chest = WorldUtil.getTileEntity(RadiantChestTileEntity.class, (IBlockAccess)world, data.getPos());
            if (chest != null && !(chestName = chest.getChestName()).isEmpty()) {
                probeInfo.text(TextFormatting.GOLD + "{*arcanearchives.data.tooltip.chest_name*} " + chestName);
            }
        } else if (block instanceof RadiantResonator) {
            RadiantResonatorTileEntity resonator = WorldUtil.getTileEntity(RadiantResonatorTileEntity.class, (IBlockAccess)world, data.getPos());
            if (resonator != null) {
                probeInfo.text(TextFormatting.GOLD + "{*arcanearchives.data.tooltip.resonator_progress*} " + String.format("%d%%", resonator.getPercentageComplete()));
                RadiantResonatorTileEntity.TickResult res = resonator.canTick();
                probeInfo.text(res.getFormat() + "{*" + res.getKey() + "*}");
            }
        } else if (block instanceof RadiantTrove && (trove = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, (IBlockAccess)world, data.getPos())) != null) {
            probeInfo.text(TextFormatting.GOLD + "" + trove.getInventory().getCount() + " {*arcanearchives.data.tooltip.trove_count*} {*" + trove.getInventory().getItem().func_77977_a() + ".name*}");
        }
    }

    @Override
    public Void apply(ITheOneProbe iTheOneProbe) {
        this.init(iTheOneProbe);
        return null;
    }

    public void init(ITheOneProbe top) {
        top.registerProvider((IProbeInfoProvider)this);
    }
}

