/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.init;

import com.aranaira.arcanearchives.api.GCTRecipeEvent;
import com.aranaira.arcanearchives.api.IGCTRecipe;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.data.ClientNetwork;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.HiveSaveData;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.integration.astralsorcery.Liquefaction;
import com.aranaira.arcanearchives.recipe.IngredientStack;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreIngredient;

@Mod.EventBusSubscriber(modid="arcanearchives")
public class RecipeLibrary {
    public static IGCTRecipe RADIANT_KEY_RECIPE;
    public static IGCTRecipe SHAPED_RADIANT_QUARTZ_RECIPE;
    public static IGCTRecipe MANIFEST_RECIPE;
    public static IGCTRecipe CONTAINMENT_FIELD_RECIPE;
    public static IGCTRecipe MATERIAL_INTERFACE_RECIPE;
    public static IGCTRecipe MATRIX_BRACE_RECIPE;
    public static IGCTRecipe RADIANT_DUST_RECIPE;
    public static IGCTRecipe SCINTILLATING_INLAY_RECIPE;
    public static IGCTRecipe DEVOURING_CHARM_RECIPE;
    public static IGCTRecipe GEM_SOCKET_RECIPE;
    public static IGCTRecipe RADIANT_LANTERN_RECIPE;
    public static IGCTRecipe RADIANT_TROVE_RECIPE;
    public static IGCTRecipe RADIANT_TANK_RECIPE;
    public static IGCTRecipe MONITORING_CRYSTAL_RECIPE;
    public static IGCTRecipe SCEPTER_MANIPULATION_RECIPE;
    public static IGCTRecipe RADIANT_AMPHORA_RECIPE;
    public static IGCTRecipe LETTER_OF_INVITATION_RECIPE;
    public static IGCTRecipe LETTER_OF_RESIGNATION_RECIPE;
    public static IGCTRecipe WRIT_OF_EXPULSION_RECIPE;
    public static IGCTRecipe BRAZIER_RECIPE;
    public static IGCTRecipe SLAUGHTERGLEAM_RECIPE;
    public static IGCTRecipe MURDERGLEAM_RECIPE;
    public static IGCTRecipe CLEANSEGLEAM_RECIPE;
    public static IGCTRecipe AGEGLEAM_RECIPE;
    public static IGCTRecipe SWITCHGLEAM_RECIPE;
    public static IGCTRecipe SALVEGLEAM_RECIPE;
    public static IGCTRecipe MUNCHSTONE_RECIPE;
    public static IGCTRecipe ORDERSTONE_RECIPE;
    public static IGCTRecipe MINDSPINDLE_RECIPE;
    public static IGCTRecipe ELIXIRSPINDLE_RECIPE;
    public static IGCTRecipe RIVERTEAR_RECIPE;
    public static IGCTRecipe MOUNTAINTEAR_RECIPE;
    public static IGCTRecipe PARCHTEAR_RECIPE;
    public static IGCTRecipe PHOENIXWAY_RECIPE;
    public static IGCTRecipe STORMWAY_RECIPE;

    public static void buildRecipes() {
        RADIANT_DUST_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("radiant_dust", new ItemStack((Item)ItemRegistry.COMPONENT_RADIANTDUST, 2), ItemRegistry.RAW_RADIANT_QUARTZ);
        SHAPED_RADIANT_QUARTZ_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("shaped_quartz", new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new ItemStack((Item)ItemRegistry.RAW_RADIANT_QUARTZ, 2));
        MANIFEST_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("manifest", new ItemStack((Item)ItemRegistry.MANIFEST, 1), new IngredientStack("paper", 1), new IngredientStack("dyeBlack", 1), new ItemStack((Item)ItemRegistry.COMPONENT_RADIANTDUST, 2));
        LETTER_OF_INVITATION_RECIPE = GCTRecipeList.instance.makeAndAddRecipeWithCreatorAndCondition("letter_invitation", new ItemStack((Item)ItemRegistry.LETTER_OF_INVITATION, 1), new IngredientStack("paper", 3), new ItemStack((Item)ItemRegistry.COMPONENT_RADIANTDUST, 1), new IngredientStack("dyeLightBlue", 1)).addCondition((player, tile) -> {
            if (!player.field_70170_p.field_72995_K) {
                HiveSaveData saveData = DataHelper.getHiveData();
                HiveSaveData.Hive hive = saveData.getHiveByMember(player.func_110124_au());
                return hive == null || hive.owner.equals(player.func_110124_au());
            }
            ClientNetwork network = DataHelper.getClientNetwork();
            return network.ownsHive() || !network.inHive();
        });
        LETTER_OF_RESIGNATION_RECIPE = GCTRecipeList.instance.makeAndAddRecipeWithCreatorAndCondition("letter_resignation", new ItemStack((Item)ItemRegistry.LETTER_OF_RESIGNATION, 1), new IngredientStack("paper", 3), new ItemStack((Item)ItemRegistry.COMPONENT_RADIANTDUST, 1), new IngredientStack("dyePink", 1)).addCondition((player, tile) -> {
            if (!player.field_70170_p.field_72995_K) {
                HiveSaveData saveData = DataHelper.getHiveData();
                HiveSaveData.Hive hive = saveData.getHiveByMember(player.func_110124_au());
                return hive != null;
            }
            ClientNetwork network = DataHelper.getClientNetwork();
            return network.inHive();
        });
        WRIT_OF_EXPULSION_RECIPE = GCTRecipeList.instance.makeAndAddRecipeWithCreatorAndCondition("writ_expulsion", new ItemStack((Item)ItemRegistry.WRIT_OF_EXPULSION, 1), new IngredientStack("paper", 3), new ItemStack((Item)ItemRegistry.COMPONENT_RADIANTDUST, 1), new IngredientStack("dyeRed", 1)).addCondition((player, tile) -> {
            if (!player.field_70170_p.field_72995_K) {
                HiveSaveData saveData = DataHelper.getHiveData();
                HiveSaveData.Hive hive = saveData.getHiveByMember(player.func_110124_au());
                return hive != null && hive.owner.equals(player.func_110124_au());
            }
            ClientNetwork network = DataHelper.getClientNetwork();
            return network.inHive() && network.ownsHive();
        });
        SCEPTER_MANIPULATION_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("scepter_manipulation", new ItemStack((Item)ItemRegistry.SCEPTER_MANIPULATION), new ItemStack((Item)ItemRegistry.SCEPTER_REVELATION, 1), new IngredientStack(ItemRegistry.SHAPED_RADIANT_QUARTZ, 1));
        RADIANT_LANTERN_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("radiant_lantern", new ItemStack((Block)BlockRegistry.RADIANT_LANTERN, 4), new ItemStack((Item)ItemRegistry.RAW_RADIANT_QUARTZ, 2), new IngredientStack("nuggetGold", 1));
        RADIANT_TROVE_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("radiant_trove", new ItemStack((Block)BlockRegistry.RADIANT_TROVE, 4), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 2), new ItemStack((Item)ItemRegistry.COMPONENT_MATERIALINTERFACE), new ItemStack((Block)BlockRegistry.RADIANT_CHEST));
        RADIANT_TANK_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("radiant_tank", new ItemStack((Block)BlockRegistry.RADIANT_TANK, 4), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 2), new ItemStack((Item)ItemRegistry.COMPONENT_CONTAINMENTFIELD), new IngredientStack("ingotGold", 1));
        MONITORING_CRYSTAL_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("monitoring_crystal", new ItemStack((Block)BlockRegistry.MONITORING_CRYSTAL), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("nuggetGold", 2), new IngredientStack("stickWood", 4));
        SCINTILLATING_INLAY_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("scintillating_inlay", new ItemStack((Item)ItemRegistry.COMPONENT_SCINTILLATINGINLAY, 1), new ItemStack((Item)ItemRegistry.COMPONENT_RADIANTDUST, 6), new IngredientStack("dustRedstone", 12), new IngredientStack("ingotGold"), new IngredientStack("nuggetGold", 6));
        BRAZIER_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("brazier_of_hoarding", new ItemStack((Block)BlockRegistry.BRAZIER_OF_HOARDING, 1), new ItemStack((Item)ItemRegistry.COMPONENT_RADIANTDUST, 4), new IngredientStack(Items.field_151044_h, 8), new IngredientStack("ingotGold", 2), new IngredientStack("logWood", 3));
        MATRIX_BRACE_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("matrix_brace", new ItemStack((Item)ItemRegistry.COMPONENT_MATRIXBRACE, 1), ItemRegistry.COMPONENT_SCINTILLATINGINLAY, new IngredientStack("ingotGold", 2));
        MATERIAL_INTERFACE_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("material_interface", new ItemStack((Item)ItemRegistry.COMPONENT_MATERIALINTERFACE, 1), ItemRegistry.COMPONENT_SCINTILLATINGINLAY, new IngredientStack("ingotGold"), ItemRegistry.SHAPED_RADIANT_QUARTZ);
        CONTAINMENT_FIELD_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("containment_field", new ItemStack((Item)ItemRegistry.COMPONENT_CONTAINMENTFIELD, 1), ItemRegistry.COMPONENT_SCINTILLATINGINLAY, new IngredientStack("ingotGold", 2), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 2));
        DEVOURING_CHARM_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("devouring_charm", new ItemStack((Item)ItemRegistry.DEVOURING_CHARM, 4), new IngredientStack("ingotGold", 1), new IngredientStack(Blocks.field_150343_Z, 2), new IngredientStack(Items.field_151033_d, 1));
        RADIANT_KEY_RECIPE = GCTRecipeList.instance.makeAndAddRecipeWithCreator("radiant_key", new ItemStack((Item)ItemRegistry.RADIANT_KEY, 4), new IngredientStack("ingotGold", 1), new IngredientStack("nuggetGold", 3), new IngredientStack(ItemRegistry.SHAPED_RADIANT_QUARTZ));
        RADIANT_AMPHORA_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("radiant_amphora", new ItemStack((Item)ItemRegistry.RADIANT_AMPHORA), new ItemStack((Item)ItemRegistry.COMPONENT_RADIANTDUST, 4), new ItemStack(Items.field_151119_aD, 4), new ItemStack(Items.field_151074_bl, 4));
        if (ConfigHandler.ArsenalConfig.EnableArsenal) {
            GEM_SOCKET_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("gemsocket", new ItemStack((Item)ItemRegistry.BAUBLE_GEMSOCKET), new ItemStack((Item)ItemRegistry.COMPONENT_SCINTILLATINGINLAY, 1), new ItemStack(Items.field_151074_bl, 4), new ItemStack(Items.field_151054_z, 1), new ItemStack(Items.field_151116_aA, 1));
            MURDERGLEAM_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("murdergleam", new ItemStack((Item)ItemRegistry.MURDERGLEAM), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyeYellow", 4), new IngredientStack(Items.field_151048_u), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151065_br), 2));
            SLAUGHTERGLEAM_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("slaughtergleam", new ItemStack((Item)ItemRegistry.SLAUGHTERGLEAM), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyeRed", 4), new IngredientStack(Items.field_151045_i), new IngredientStack(Items.field_151043_k, 2), new IngredientStack(Blocks.field_150368_y, 2));
            AGEGLEAM_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("agegleam", new ItemStack((Item)ItemRegistry.AGEGLEAM), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyeGreen", 4), new IngredientStack(Items.field_151015_O, 9), new IngredientStack(Items.field_151172_bF, 9), new IngredientStack(Items.field_151014_N, 9));
            CLEANSEGLEAM_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("cleansegleam", new ItemStack((Item)ItemRegistry.CLEANSEGLEAM), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyeBlue", 4), new IngredientStack(Items.field_151170_bI), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151117_aB), 1));
            SWITCHGLEAM_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("switchgleam", new ItemStack((Item)ItemRegistry.SWITCHGLEAM), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyePurple", 4), new IngredientStack((Block)Blocks.field_150479_bC), new IngredientStack(Items.field_151079_bi));
            SALVEGLEAM_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("salvegleam", new ItemStack((Item)ItemRegistry.SALVEGLEAM), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyePink", 4), new IngredientStack(Items.field_151153_ao), new IngredientStack(Items.field_151060_bw), new IngredientStack(Items.field_151150_bK));
            MUNCHSTONE_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("munchstone", new ItemStack((Item)ItemRegistry.MUNCHSTONE), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyeBlack", 4), new IngredientStack(Items.field_151105_aU), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151060_bw), 2));
            ORDERSTONE_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("orderstone", new ItemStack((Item)ItemRegistry.ORDERSTONE), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyePink", 4), new IngredientStack(Blocks.field_150467_bQ), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151155_ap), 30));
            MINDSPINDLE_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("mindspindle", new ItemStack((Item)ItemRegistry.MINDSPINDLE), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyeGreen", 4), new IngredientStack(Items.field_151134_bR), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151166_bC), 2));
            ELIXIRSPINDLE_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("elixirspindle", new ItemStack((Item)ItemRegistry.ELIXIRSPINDLE), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyePurple", 4), new IngredientStack(Items.field_151067_bt), new IngredientStack(Items.field_151166_bC, 2), new IngredientStack(Items.field_151137_ax, 4), new IngredientStack(Items.field_151114_aO, 4));
            RIVERTEAR_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("rivertear", new ItemStack((Item)ItemRegistry.RIVERTEAR), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151102_aT), 4), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151131_as)), new IngredientStack((Ingredient)new OreIngredient("dyeBlue"), 4));
            MOUNTAINTEAR_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("mountaintear", new ItemStack((Item)ItemRegistry.MOUNTAINTEAR), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyeOrange", 4), new IngredientStack(Blocks.field_189877_df, 4), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151129_at)));
            PARCHTEAR_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("parchtear", new ItemStack((Item)ItemRegistry.PARCHTEAR), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyeBlack", 4), new IngredientStack(Blocks.field_150405_ch, 4), new IngredientStack((Block)Blocks.field_150330_I, 4));
            PHOENIXWAY_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("phoenixway", new ItemStack((Item)ItemRegistry.PHOENIXWAY), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151065_br), 4), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151044_h), 4), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151033_d)));
            STORMWAY_RECIPE = GCTRecipeList.instance.makeAndAddRecipe("stormway", new ItemStack((Item)ItemRegistry.STORMWAY), new ItemStack((Item)ItemRegistry.SHAPED_RADIANT_QUARTZ, 1), new IngredientStack("dyeYellow", 4), new IngredientStack(Ingredient.func_193367_a((Item)Items.field_151137_ax), 16), new IngredientStack(Blocks.field_150411_aY, 8));
        }
        GCTRecipeEvent event = new GCTRecipeEvent(GCTRecipeList.instance);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @SubscribeEvent
    public static void integrationEventAS(RegistryEvent.Register<IRecipe> event) {
        if (Loader.isModLoaded((String)"astralsorcery")) {
            Liquefaction.init();
        }
    }
}

