/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.events.mappings;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.init.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="arcanearchives")
public class MappingHandler {
    @SubscribeEvent
    public static void onItemMappingsEvent(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            Item item = null;
            if (entry.key.func_110624_b().equals("arcanearchives")) {
                if (entry.key.func_110623_a().equals(ItemRegistry.GBOOK_ARSENAL_CONDITION.getRegistryName().func_110623_a())) {
                    entry.ignore();
                    return;
                }
                item = MappingHandler.lookupItem(entry.key);
            } else if (entry.key.func_110624_b().equals("gbook") && entry.key.func_110623_a().equals("guidebook")) {
                item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("gbook_snapshot:guidebook"));
            }
            if (item == null) continue;
            entry.remap(item);
        }
    }

    @SubscribeEvent
    public static void onBlockMappingsEvent(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            if (entry.key.func_110624_b().equals("arcanearchives") && entry.key.func_110623_a().equals("raw_quartz")) {
                entry.remap((IForgeRegistryEntry)BlockRegistry.RAW_QUARTZ);
            }
            if (!entry.key.func_110624_b().equals("arcanearchives") || !entry.key.func_110623_a().equals("storage_cut_quartz")) continue;
            entry.remap((IForgeRegistryEntry)BlockRegistry.STORAGE_SHAPED_QUARTZ);
        }
    }

    public static Item lookupItem(ResourceLocation resource) {
        switch (resource.func_110623_a()) {
            case "bauble_gemsocket": {
                return ItemRegistry.BAUBLE_GEMSOCKET;
            }
            case "item_component_containmentfield": {
                return ItemRegistry.COMPONENT_CONTAINMENTFIELD;
            }
            case "item_component_materialinterface": {
                return ItemRegistry.COMPONENT_MATERIALINTERFACE;
            }
            case "item_component_matrixbrace": {
                return ItemRegistry.COMPONENT_MATRIXBRACE;
            }
            case "item_component_radiantdust": {
                return ItemRegistry.COMPONENT_RADIANTDUST;
            }
            case "item_component_scintillatinginlay": {
                return ItemRegistry.COMPONENT_SCINTILLATINGINLAY;
            }
            case "item_murdergleam": {
                return ItemRegistry.MURDERGLEAM;
            }
            case "item_munchstone": {
                return ItemRegistry.MUNCHSTONE;
            }
            case "item_mindspindle": {
                return ItemRegistry.MINDSPINDLE;
            }
            case "item_mountaintear": {
                return ItemRegistry.MOUNTAINTEAR;
            }
            case "item_rivertear": {
                return ItemRegistry.RIVERTEAR;
            }
            case "item_phoenixway": {
                return ItemRegistry.PHOENIXWAY;
            }
            case "item_letterofinvitation": {
                return ItemRegistry.LETTER_OF_INVITATION;
            }
            case "item_letterofresignation": {
                return ItemRegistry.LETTER_OF_RESIGNATION;
            }
            case "item_manifest": {
                return ItemRegistry.MANIFEST;
            }
            case "item_rawquartz": {
                return ItemRegistry.RAW_RADIANT_QUARTZ;
            }
            case "item_sceptermanipulation": {
                return ItemRegistry.SCEPTER_MANIPULATION;
            }
            case "item_scepterrevelation": {
                return ItemRegistry.SCEPTER_REVELATION;
            }
            case "item_cutquartz": {
                return ItemRegistry.SHAPED_RADIANT_QUARTZ;
            }
            case "item_tomeofarcana": {
                return ItemRegistry.TOME_OF_ARCANA;
            }
            case "item_writofexpulsion": {
                return ItemRegistry.WRIT_OF_EXPULSION;
            }
        }
        ArcaneArchives.logger.error("#############################################################");
        ArcaneArchives.logger.error("Unable to handle missing mapping for ResourceLocation " + resource.toString() + " and it has not been replaced.");
        ArcaneArchives.logger.error("#############################################################");
        return null;
    }
}

