/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.events;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantResonatorTileEntity;
import com.aranaira.arcanearchives.tileentities.unused.MatrixCoreTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="arcanearchives")
public class ServerTickHandler {
    private static final List<ImmanenceTileEntity> incomingITEs = new ArrayList<ImmanenceTileEntity>();
    private static final List<ImmanenceTileEntity> outgoingITEs = new ArrayList<ImmanenceTileEntity>();
    private static final List<ImmanenceTileEntity> limitedITEs = new ArrayList<ImmanenceTileEntity>();

    public static void incomingITE(ImmanenceTileEntity entity) {
        incomingITEs.add(entity);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ServerNetwork network;
        UUID networkId;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<ImmanenceTileEntity> consumed = new ArrayList<ImmanenceTileEntity>();
        if (!limitedITEs.isEmpty()) {
            for (ImmanenceTileEntity ite : limitedITEs) {
                networkId = ite.networkId;
                if (networkId == null || networkId.equals(DataHelper.INVALID) || (network = DataHelper.getServerNetwork(networkId)) == null) continue;
                if (ite.uuid != null && !network.isSafe(ite.uuid)) {
                    ServerTickHandler.outgoingITE(ite);
                }
                consumed.add(ite);
            }
        }
        limitedITEs.removeAll(consumed);
        consumed.clear();
        for (ImmanenceTileEntity ite : incomingITEs) {
            if (ite.ticks() > 30) {
                ServerTickHandler.outgoingITE(ite);
                ArcaneArchives.logger.debug(String.format("Tile entity with the class %s spent 30 ticks in the queue and is being discarded.", ((Object)((Object)ite)).getClass().getName()));
            } else {
                networkId = ite.networkId;
                if (networkId == null || networkId.equals(DataHelper.INVALID)) {
                    ite.tick();
                    continue;
                }
                network = DataHelper.getServerNetwork(networkId);
                if (network == null) continue;
                ite.tryGenerateUUID();
                if (!network.containsTile(ite)) {
                    network.addTile(ite);
                } else {
                    network.updateTile(ite);
                }
                if (ite instanceof RadiantResonatorTileEntity || ite instanceof MatrixCoreTileEntity) {
                    ServerTickHandler.limitedITE(ite);
                }
            }
            consumed.add(ite);
        }
        incomingITEs.removeAll(consumed);
        for (ImmanenceTileEntity ite : outgoingITEs) {
            if (ite.func_145837_r()) continue;
            ite.breakBlock();
        }
        outgoingITEs.clear();
    }

    private static void limitedITE(ImmanenceTileEntity entity) {
        limitedITEs.add(entity);
    }

    private static void outgoingITE(ImmanenceTileEntity entity) {
        outgoingITEs.add(entity);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerNetwork network = DataHelper.getServerNetwork(event.player.func_110124_au());
        if (network != null) {
            network.rebuildTotals();
        }
    }
}

