/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.data;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class HiveSaveData
extends WorldSavedData {
    public static final String ID = "Archane-Archives-Hives";
    public Map<UUID, Hive> ownerToHive = new HashMap<UUID, Hive>();

    public HiveSaveData(String name) {
        super(name);
    }

    public HiveSaveData() {
        super(ID);
    }

    public Set<UUID> getHiveOwners() {
        return Sets.newHashSet(this.ownerToHive.keySet());
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("hive_data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Hive hive = Hive.fromNBT(list.func_150305_b(i));
            if (hive == null) continue;
            this.ownerToHive.put(hive.owner, hive);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Hive hive : this.ownerToHive.values()) {
            list.func_74742_a((NBTBase)hive.writeToNBT());
        }
        compound.func_74782_a("hive_data", (NBTBase)list);
        return compound;
    }

    public Hive getHiveByOwner(UUID owner) {
        if (this.ownerToHive.get(owner) == null) {
            Hive hive = new Hive(owner);
            this.ownerToHive.put(owner, hive);
            this.func_76185_a();
        }
        return this.ownerToHive.get(owner);
    }

    public boolean validateHive(Hive hive, @Nullable UUID owner, @Nullable UUID member) {
        if (hive.members.isEmpty()) {
            this.ownerToHive.remove(hive.owner);
            if (owner != null) {
                this.ownerToHive.remove(owner);
            }
            return false;
        }
        if (owner != null && !hive.owner.equals(owner)) {
            this.ownerToHive.remove(owner);
            this.ownerToHive.put(hive.owner, hive);
            return member == null || hive.members.contains(member);
        }
        return true;
    }

    @Nullable
    public Hive getHiveByMember(UUID member) {
        Hive ownerHive = this.ownerToHive.get(member);
        if (ownerHive != null && this.validateHive(ownerHive, member, null)) {
            return ownerHive;
        }
        for (Hive hive : this.ownerToHive.values()) {
            if (!hive.members.contains(member) || !this.validateHive(hive, null, member)) continue;
            return hive;
        }
        return null;
    }

    public boolean addMember(Hive hive, UUID newMember) {
        if (hive.owner.equals(newMember)) {
            return false;
        }
        if (hive.members.contains(newMember)) {
            return false;
        }
        if (this.getHiveByMember(newMember) != null) {
            return false;
        }
        hive.members.add(newMember);
        this.func_76185_a();
        return true;
    }

    public boolean removeMember(Hive hive, UUID memberToRemove) {
        boolean result = false;
        if (hive.owner.equals(memberToRemove)) {
            result = true;
            UUID oldest = hive.getOldestMember();
            hive.members.remove(oldest);
            hive.owner = oldest;
            this.ownerToHive.remove(memberToRemove);
            this.ownerToHive.put(oldest, hive);
        } else if (hive.members.remove(memberToRemove)) {
            result = true;
        }
        this.handlePotentialDisband(hive);
        this.func_76185_a();
        return result;
    }

    public void handlePotentialDisband(Hive hive) {
        boolean doDisband;
        if (hive.members.isEmpty()) {
            doDisband = true;
        } else {
            doDisband = true;
            for (UUID member : hive.members) {
                if (member.equals(hive.owner)) continue;
                doDisband = false;
            }
        }
        if (doDisband) {
            this.ownerToHive.remove(hive.owner);
            hive.disbanded = true;
        }
    }

    public void alertMembers(World world, Hive hive, UUID newMember, boolean joined) {
        String name;
        ArrayList<UUID> members = new ArrayList<UUID>(hive.members);
        PlayerProfileCache cache = world.func_73046_m().func_152358_ax();
        GameProfile profile = cache.func_152652_a(newMember);
        String string = name = profile == null ? "Unknown" : profile.getName();
        if (members.isEmpty()) {
            EntityPlayer player = world.func_152378_a(hive.owner);
            if (player != null) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.network.hive.disbanded", new Object[]{name}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
            }
            return;
        }
        members.add(hive.owner);
        for (UUID uuid : members) {
            EntityPlayer player;
            if (uuid.equals(newMember) || (player = world.func_152378_a(uuid)) == null) continue;
            if (joined) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.network.hive.joined_your_network", new Object[]{name}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
                continue;
            }
            player.func_145747_a(new TextComponentTranslation("arcanearchives.network.hive.left_your_network", new Object[]{name}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        }
    }

    public static class Hive {
        public UUID owner;
        public LinkedHashSet<UUID> members = new LinkedHashSet();
        public boolean disbanded = false;

        public Hive(UUID owner) {
            this.owner = owner;
        }

        public void setOwner(UUID owner) {
            this.owner = owner;
        }

        @Nullable
        public UUID getOldestMember() {
            if (this.members.isEmpty()) {
                return null;
            }
            return (UUID)this.members.iterator().next();
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound result = new NBTTagCompound();
            result.func_186854_a("owner", this.owner);
            NBTTagList members = new NBTTagList();
            for (UUID member : this.members) {
                NBTTagCompound m = new NBTTagCompound();
                m.func_186854_a("uuid", member);
                members.func_74742_a((NBTBase)m);
            }
            result.func_74782_a("members", (NBTBase)members);
            return result;
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.owner = tag.func_186857_a("owner");
            this.members.clear();
            NBTTagList members = tag.func_150295_c("members", 10);
            for (int i = 0; i < members.func_74745_c(); ++i) {
                UUID incoming = members.func_150305_b(i).func_186857_a("uuid");
                if (this.owner.equals(incoming)) continue;
                this.members.add(incoming);
            }
        }

        @Nullable
        public static Hive fromNBT(NBTTagCompound tag) {
            Hive hive = new Hive(null);
            hive.readFromNBT(tag);
            if (hive.members.isEmpty()) {
                return null;
            }
            return hive;
        }
    }
}

