/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.data;

import com.aranaira.arcanearchives.data.IHiveBase;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.types.IteRef;
import com.aranaira.arcanearchives.types.lists.CombinedTileList;
import com.aranaira.arcanearchives.types.lists.ITileList;
import com.aranaira.arcanearchives.util.TileUtils;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class HiveNetwork
implements IHiveBase {
    private List<ServerNetwork> memberNetworks;
    private ServerNetwork ownerNetwork;

    public HiveNetwork(ServerNetwork ownerNetwork, List<ServerNetwork> memberNetworks) {
        this.ownerNetwork = ownerNetwork;
        this.memberNetworks = memberNetworks;
    }

    private void applyToHive(Consumer<ServerNetwork> consumer) {
        consumer.accept(this.ownerNetwork);
        this.memberNetworks.forEach(consumer);
    }

    private boolean applyToHive(Predicate<ServerNetwork> predicate) {
        if (predicate.test((Object)this.ownerNetwork)) {
            return true;
        }
        for (ServerNetwork network : this.memberNetworks) {
            if (!predicate.test((Object)network)) continue;
            return true;
        }
        return false;
    }

    private List<ServerNetwork> getCombinedNetworks() {
        ArrayList<ServerNetwork> combined = new ArrayList<ServerNetwork>(this.getContainedNetworks());
        combined.add(this.ownerNetwork);
        return combined;
    }

    @Override
    @Nullable
    public ServerNetwork getOwnerNetwork() {
        return this.ownerNetwork;
    }

    @Override
    @Nullable
    public HiveNetwork getHiveNetwork() {
        return this;
    }

    @Override
    public boolean isHiveMember() {
        return true;
    }

    @Override
    public boolean anyLoaded() {
        return false;
    }

    @Override
    public ITileList getTiles() {
        ArrayList<ITileList> tiles = new ArrayList<ITileList>();
        for (ServerNetwork network : this.getCombinedNetworks()) {
            tiles.add(network.getTiles());
        }
        return new CombinedTileList(tiles);
    }

    @Override
    public Iterable<IteRef> getValidTiles() {
        return TileUtils.filterValid(this.getTiles());
    }

    @Override
    public List<ServerNetwork> getContainedNetworks() {
        return this.memberNetworks;
    }

    @Override
    public void clearTiles() {
        this.getContainedNetworks().forEach(ServerNetwork::clearTiles);
    }

    @Nullable
    public ServerNetwork getContainedNetwork(EntityPlayer player) {
        for (ServerNetwork network : this.getCombinedNetworks()) {
            if (!network.getUuid().equals(player.func_110124_au())) continue;
            return network;
        }
        return null;
    }
}

