/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.data;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.data.ClientNetwork;
import com.aranaira.arcanearchives.data.HiveMembershipInfo;
import com.aranaira.arcanearchives.data.HiveNetwork;
import com.aranaira.arcanearchives.data.HiveSaveData;
import com.aranaira.arcanearchives.data.IHiveBase;
import com.aranaira.arcanearchives.data.NetworkSaveData;
import com.aranaira.arcanearchives.data.PlayerSaveData;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DataHelper {
    public static UUID INVALID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private static Map<UUID, ClientNetwork> CLIENT_MAP = new HashMap<UUID, ClientNetwork>();

    public static void clearClientCache() {
        CLIENT_MAP.clear();
    }

    @Nullable
    public static ServerNetwork getServerNetwork(UUID uuid) {
        WorldServer world = DataHelper.getWorld();
        if (!DataHelper.checkUUID(uuid) || !DataHelper.checkWorld(world)) {
            return null;
        }
        NetworkSaveData saveData = DataHelper.getNetworkData();
        return saveData.getNetwork(uuid);
    }

    public static WorldServer getWorld() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
    }

    public static ServerList getNetworks() {
        NetworkSaveData networkData = DataHelper.getNetworkData();
        HiveSaveData hiveData = DataHelper.getHiveData();
        ArrayList<ServerNetwork> independents = new ArrayList<ServerNetwork>();
        ArrayList<HiveNetwork> hives = new ArrayList<HiveNetwork>();
        HashSet<UUID> hiveMembers = new HashSet<UUID>();
        Set<UUID> ownerUuids = hiveData.getHiveOwners();
        Collection<ServerNetwork> baseNetworks = networkData.getAllNetworks();
        for (ServerNetwork network : baseNetworks) {
            UUID nid = network.getUuid();
            if (ownerUuids.contains(nid)) {
                HiveNetwork hive = network.getHiveNetwork();
                hives.add(hive);
                for (ServerNetwork contained : hive.getContainedNetworks()) {
                    hiveMembers.add(contained.getUuid());
                }
                continue;
            }
            if (hiveMembers.contains(nid)) continue;
            independents.add(network);
        }
        return new ServerList(independents, hives);
    }

    public static NetworkSaveData getNetworkData() {
        WorldServer world = DataHelper.getWorld();
        NetworkSaveData saveData = (NetworkSaveData)Objects.requireNonNull(world.func_175693_T()).func_75742_a(NetworkSaveData.class, "Archane-Archives-Network");
        if (saveData == null) {
            saveData = new NetworkSaveData();
            world.func_175693_T().func_75745_a("Archane-Archives-Network", (WorldSavedData)saveData);
        }
        return saveData;
    }

    public static PlayerSaveData getPlayerData(EntityPlayer player) {
        WorldServer world = DataHelper.getWorld();
        PlayerSaveData saveData = (PlayerSaveData)Objects.requireNonNull(world.func_175693_T()).func_75742_a(PlayerSaveData.class, PlayerSaveData.ID(player));
        if (saveData == null) {
            saveData = new PlayerSaveData(player);
            world.func_175693_T().func_75745_a(saveData.getId(), (WorldSavedData)saveData);
        }
        return saveData;
    }

    public static HiveSaveData getHiveData() {
        WorldServer world = DataHelper.getWorld();
        HiveSaveData saveData = (HiveSaveData)Objects.requireNonNull(world.func_175693_T()).func_75742_a(HiveSaveData.class, "Archane-Archives-Hives");
        if (saveData == null) {
            saveData = new HiveSaveData();
            world.func_175693_T().func_75745_a("Archane-Archives-Hives", (WorldSavedData)saveData);
        }
        return saveData;
    }

    @Nullable
    public static HiveMembershipInfo getHiveMembershipInfo(UUID uuid) {
        if (!DataHelper.checkUUID(uuid)) {
            return null;
        }
        HiveSaveData saveData = DataHelper.getHiveData();
        HiveSaveData.Hive hive = saveData.getHiveByMember(uuid);
        HiveMembershipInfo info = new HiveMembershipInfo();
        if (hive == null) {
            return info;
        }
        if (hive.owner.equals(uuid)) {
            info.isOwner = true;
            info.inHive = true;
        }
        if (hive.members.contains(uuid)) {
            info.inHive = true;
        }
        return info;
    }

    public static boolean isHiveMember(UUID uuid) {
        if (!DataHelper.checkUUID(uuid)) {
            return false;
        }
        HiveSaveData saveData = DataHelper.getHiveData();
        return saveData.getHiveByMember(uuid) != null;
    }

    @Nullable
    public static HiveNetwork getHiveNetwork(UUID uuid) {
        if (!DataHelper.checkUUID(uuid)) {
            return null;
        }
        HiveSaveData saveData = DataHelper.getHiveData();
        HiveSaveData.Hive hive = saveData.getHiveByMember(uuid);
        if (hive == null) {
            return null;
        }
        return DataHelper.getHiveNetwork(hive);
    }

    public static HiveNetwork getHiveNetwork(HiveSaveData.Hive hive) {
        ServerNetwork owner = DataHelper.getServerNetwork(hive.owner);
        ArrayList<ServerNetwork> members = new ArrayList<ServerNetwork>();
        for (UUID member : hive.members) {
            ServerNetwork m = DataHelper.getServerNetwork(member);
            if (m == null) {
                ArcaneArchives.logger.error("Attempted to insert a null network for member " + member.toString() + " into Hive for " + hive.owner.toString(), (Throwable)new InvalidNetworkException("Null Hive Member"));
                continue;
            }
            members.add(m);
        }
        return new HiveNetwork(owner, members);
    }

    public static boolean checkUUID(UUID uuid) {
        if (uuid == null) {
            ArcaneArchives.logger.warn("Attempted to fetch a network with a null UUID", (Throwable)new InvalidNetworkException("Null Network UUID"));
            return false;
        }
        if (uuid.equals(INVALID)) {
            ArcaneArchives.logger.warn("Attempted to fetch a network with a blank (invalid) UUID", (Throwable)new InvalidNetworkException("Invalid UUID"));
            return false;
        }
        return true;
    }

    public static boolean checkWorld(WorldServer world) {
        if (world == null) {
            ArcaneArchives.logger.error("Attempted to load a network, but the world is null!", (Throwable)new InvalidNetworkException("World is null"));
            return false;
        }
        if (world.func_175693_T() == null) {
            ArcaneArchives.logger.error("Attempted to load a network, but the world's map storage is null!", (Throwable)new InvalidNetworkException("Map Storage is null"));
            return false;
        }
        return true;
    }

    public static ClientNetwork getClientNetwork(UUID uuid) {
        if (uuid == null || uuid.equals(INVALID)) {
            return null;
        }
        if (CLIENT_MAP.containsKey(uuid)) {
            return CLIENT_MAP.get(uuid);
        }
        ClientNetwork net = new ClientNetwork(uuid);
        CLIENT_MAP.put(uuid, net);
        return net;
    }

    @SideOnly(value=Side.CLIENT)
    public static ClientNetwork getClientNetwork() {
        Minecraft mc = Minecraft.func_71410_x();
        UUID id = mc.field_71439_g.func_110124_au();
        return DataHelper.getClientNetwork(id);
    }

    public static class InvalidNetworkException
    extends NullPointerException {
        InvalidNetworkException(String s) {
            super(s);
        }
    }

    public static class ServerList
    implements Iterable<IHiveBase> {
        public List<ServerNetwork> independents;
        public List<HiveNetwork> hives;

        public ServerList(List<ServerNetwork> independents, List<HiveNetwork> hives) {
            this.independents = independents;
            this.hives = hives;
        }

        @Override
        @Nonnull
        public Iterator<IHiveBase> iterator() {
            return Iterators.concat(this.independents.iterator(), this.hives.iterator());
        }
    }
}

