/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.data;

import com.aranaira.arcanearchives.data.HiveMembershipInfo;
import com.aranaira.arcanearchives.data.SynchroniseInfo;
import com.aranaira.arcanearchives.inventory.handlers.ManifestItemHandler;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketNetworks;
import com.aranaira.arcanearchives.types.lists.ManifestList;
import com.aranaira.arcanearchives.util.ManifestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientNetwork {
    public ManifestList manifestItems = new ManifestList((List<ManifestUtils.CollatedEntry>)new ArrayList<ManifestUtils.CollatedEntry>());
    private int totalResonators = 0;
    private int totalCores = 0;
    private Consumer<ManifestItemHandler> callback = null;
    private ManifestItemHandler manifestItemHandler = new ManifestItemHandler(this.manifestItems);
    private boolean inHive = false;
    private boolean ownsHive = false;

    ClientNetwork(UUID id) {
    }

    public int getTotalResonators() {
        return this.totalResonators;
    }

    public int getTotalCores() {
        return this.totalCores;
    }

    public ManifestItemHandler getManifestHandler() {
        return this.manifestItemHandler;
    }

    public void synchroniseData() {
        PacketNetworks.Request request = new PacketNetworks.Request(PacketNetworks.SynchroniseType.DATA);
        Networking.CHANNEL.sendToServer((IMessage)request);
    }

    public void synchroniseManifest() {
        PacketNetworks.Request request = new PacketNetworks.Request(PacketNetworks.SynchroniseType.MANIFEST);
        Networking.CHANNEL.sendToServer((IMessage)request);
    }

    public void synchroniseManifest(Consumer<ManifestItemHandler> callback) {
        this.callback = callback;
        this.synchroniseManifest();
    }

    public void deserializeManifest(ManifestList data) {
        if (data == null) {
            return;
        }
        this.manifestItems.clear();
        this.manifestItems.addAll((Collection)((Object)data));
        this.manifestItems.deserializationFinished();
        this.manifestItemHandler.nullify();
        if (this.callback != null) {
            this.callback.accept(this.manifestItemHandler);
            this.callback = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void deserializeData(SynchroniseInfo info) {
        this.totalCores = info.totalCores;
        this.totalResonators = info.totalResonators;
    }

    public void deserializeHive(HiveMembershipInfo info) {
        this.inHive = info.inHive;
        this.ownsHive = info.isOwner;
    }

    public boolean inHive() {
        return this.inHive;
    }

    public boolean ownsHive() {
        return this.ownsHive;
    }
}

