/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.config;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.client.gui.GUIManifest;
import com.aranaira.arcanearchives.items.gems.oval.MunchstoneItem;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Config.LangKey(value="arcanearchives.config.general")
@Config(modid="arcanearchives")
@Mod.EventBusSubscriber(modid="arcanearchives")
public class ConfigHandler {
    @Config.Ignore
    public static boolean UnbreakableContainers = false;
    @Config.Comment(value={"Disable to use default Minecraft-style GUI elements. (Client Only)"})
    @Config.Name(value="Use Pretty GUIs")
    public static boolean UsePrettyGUIs = true;
    @Config.Comment(value={"Set to true to mark all new chests with the no-new-items routing type"})
    @Config.Name(value="Default Radiant Chests to 'No New Items' routing")
    public static boolean defaultRoutingNoNewItems = false;
    @Config.Comment(value={"Set to true to dispense an entire stack for left click; false to dispense a single item for left click"})
    @Config.Name(value="Troves Dispense Entire Stack")
    public static boolean trovesDispense = true;
    @Config.Comment(value={"Settings related to server-side configuration"})
    @Config.Name(value="Server Settings")
    public static ServerSideConfig serverSideConfig = new ServerSideConfig();
    @Config.Comment(value={"Settings related to item tracking in non-mod containers"})
    @Config.Name(value="Non-Mod Tracking (Client-Only)")
    public static NonModTrackingConfig nonModTrackingConfig = new NonModTrackingConfig();
    @Config.LangKey(value="arcanearchives.config.manifest")
    public static ManifestConfig ManifestConfig = new ManifestConfig();
    @Config.LangKey(value="arcanearchives.config.arsenal")
    public static ArsenalConfig ArsenalConfig = new ArsenalConfig();
    @Config.Comment(value={"Settings related to sounds"})
    @Config.Name(value="Sound Settings")
    public static SoundConfig soundConfig = new SoundConfig();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("arcanearchives")) {
            ConfigManager.sync((String)"arcanearchives", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public static void onClientConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("arcanearchives")) {
            PacketConfig.MaxDistance packet = new PacketConfig.MaxDistance(ConfigHandler.ManifestConfig.MaxDistance);
            Networking.CHANNEL.sendToServer((IMessage)packet);
            PacketConfig.DefaultRoutingType packet2 = new PacketConfig.DefaultRoutingType(defaultRoutingNoNewItems);
            Networking.CHANNEL.sendToServer((IMessage)packet2);
            PacketConfig.TrovesDispense packet3 = new PacketConfig.TrovesDispense(trovesDispense);
            Networking.CHANNEL.sendToServer((IMessage)packet3);
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71462_r instanceof GUIManifest) {
                ((GUIManifest)minecraft.field_71462_r).doRefresh();
            }
        }
    }

    public static class SoundConfig {
        @Config.Comment(value={"Set to false to disable the Resonator completion sound"})
        @Config.Name(value="Resonator Complete Sound")
        public boolean resonatorComplete = true;
        @Config.Comment(value={"Set to false to disable the Resonator ticking sound"})
        @Config.Name(value="Resonator Ticking Sound")
        public boolean resonatorTicking = true;
        @Config.Comment(value={"Set to the volume you wish the resonator to tick at"})
        @Config.Name(value="Resonator Tick Volume")
        public float resonatorVolume = 0.15f;
        @Config.Comment(value={"Set to false to disable the Brazier item pick-up sound"})
        @Config.Name(value="Brazier Pickup Sound")
        public boolean brazierPickup = true;
        @Config.Comment(value={"Set to false to disable all sounds"})
        @Config.Name(value="Use Sounds")
        public boolean useSounds = true;
    }

    public static class ArsenalConfig {
        @Config.Comment(value={"Enable the Arcane Arsenal module. When disabled, items will still be registered but not craftable or visible in JEI."})
        @Config.Name(value="Enable Arsenal")
        @Config.RequiresMcRestart
        public boolean EnableArsenal = false;
        @Config.Comment(value={"Enable colour-blind mode for Arsenal. This replaces gem icons specifically with variants more clearly defined for types of colour-blindness"})
        @Config.Name(value="Colourblind Mode")
        public boolean ColourblindMode = false;
        @Config.Comment(value={"What blocks a Munchstone can eat. First value is a block (such as minecraft:log), second value is the amount of hunger restored. Saturation always equals the hunger restoration."})
        @Config.Name(value="Valid Munchstone Blocks")
        @Config.RequiresMcRestart
        public String[] MunchstoneValidEntries = MunchstoneItem.DEFAULT_ENTRIES;
    }

    public static class ManifestConfig {
        @Config.Comment(value={"Whether having a manifest in your inventory is required to open the manifest screen using a Hotkey."})
        @Config.Name(value="Manifest Presence")
        public boolean ManifestPresence = true;
        @Config.Comment(value={"Disable overlay of grid on Manifest."})
        @Config.Name(value="Disable Manifest Grid")
        public boolean DisableManifestGrid = true;
        @Config.Comment(value={"Maximum distance in blocks to track chests from for the Manifest from your current position. Useful when a member of a Hive Network."})
        @Config.Name(value="Max distance for items")
        public int MaxDistance = 100;
        @Config.Comment(value={"Synchronise the currently searched item into the JEI search box. The previous JEI search term will be restored upon closing. [Requires JEI installed]"})
        @Config.Name(value="Synchronise JEI with Search Bar")
        public boolean jeiSynchronise = false;
        @Config.Comment(value={"Whether or not the previous search term persists between 'sessions' (i.e., each time you open the manifest, your previous search term is filled in for you)"})
        @Config.Name(value="Search Term Persistence")
        public boolean searchTermPersistence = false;
        @Config.Comment(value={"Set to true to require holding shift to *close* the manifest after clicking on an item. Otherwise, holding shift will keep the manifest open."})
        @Config.Name(value="Hold Shift To Keep Manifest Open")
        public boolean holdShift = true;
    }

    public static class NonModTrackingConfig {
        @Config.Comment(value={"Container classes to exclude from Mixin-based slot highlighting"})
        @Config.Name(value="Container class to ignore")
        public String[] ContainerClasses = new String[0];
        @Config.Ignore
        private List<Class> containerClasses = null;
        @Config.Comment(value={"Set to true to disable non-Arcane Archive container slots from being highlighted when tracking items"})
        @Config.Name(value="Disable non-mod slot highlighting")
        public boolean DisableMixinHighlight = false;

        public List<Class> getContainerClasses() {
            if (this.containerClasses == null) {
                Class<GuiContainer> container = GuiContainer.class;
                this.containerClasses = new ArrayList<Class>();
                for (String clazz : this.ContainerClasses) {
                    Class<GuiContainer> clz;
                    try {
                        clz = Class.forName(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        ArcaneArchives.logger.debug("Unable to resolve class " + clazz + " so skipping.");
                        continue;
                    }
                    if (clz.isAssignableFrom(container)) {
                        this.containerClasses.add(clz);
                        continue;
                    }
                    ArcaneArchives.logger.debug("Skipping " + clazz + " as it does not derive from GuiContainer.");
                }
            }
            return this.containerClasses;
        }
    }

    public static class ServerSideConfig {
        @Config.Comment(value={"Limit of resonators per player's network"})
        @Config.Name(value="Resonator Limit")
        public int ResonatorLimit = 3;
        @Config.Comment(value={"Number of ticks it takes to create raw quartz"})
        @Config.Name(value="Resonator Time")
        public int ResonatorTickTime = 6000;
        @Config.Comment(value={"The multiplier applied to Radiant Chest slots"})
        @Config.Name(value="Radiant Chest Slot Multiplier")
        @Config.RangeInt(min=1, max=8)
        public int RadiantMultiplier = 4;
        @Config.Comment(value={"Whether or not players should be granted the book from breaking bookshelves"})
        @Config.Name(value="Book from Breaking Bookshelf")
        public boolean BookFromBookshelf = true;
        @Config.Comment(value={"Whether or not players should be granted the book for crafting their first Resonator"})
        @Config.Name(value="Book from Radiant Resonator")
        public boolean BookFromResonator = true;
        @Config.Comment(value={"The chance out of 100 that bashing a piece of Raw Radiant Quartz generates a single Sliver of Light"})
        @Config.Name(value="Chance for Single Sliver of Light")
        public int ChanceForSliverSingle = 40;
        @Config.Comment(value={"The chance out of 100 that bashing a piece of Raw Radiant Quartz generates a cluster of Slivers of Lights and is destroyed"})
        @Config.Name(value="Chance for Cluster of Slivers of Light")
        public int ChanceForSliverCluster = 20;
        @Config.Comment(value={"The minimum number of Slivers of Light generated when a piece of Raw Radiant Quartz is bashed and shattered"})
        @Config.Name(value="Minimum Slivers in Cluster")
        public int AmountGeneratedOnSliverClusterMinimum = 8;
        @Config.Comment(value={"The maximum number of Slivers of Light generated when a piece of Raw Radiant Quartz is bashed and shattered"})
        @Config.Name(value="Maximum Slivers in Cluster")
        public int AmountGeneratedOnSliverClusterMaximum = 24;
        @Config.Comment(value={"Whether or not chests can be converted into their radiant equivalents by sneak-right-clicking with raw quartz"})
        @Config.Name(value="In-World Chest To Radiant Chest Conversion")
        public boolean InWorldChestConversion = true;
    }
}

