/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.render;

import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import com.aranaira.arcanearchives.util.MathUtils;
import com.aranaira.arcanearchives.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="arcanearchives")
public class RenderHUD {
    private RenderHUD() {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        RadiantTroveTileEntity te;
        IBlockState state;
        Block block;
        RayTraceResult pos;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && (pos = mc.field_71476_x) != null && pos.field_72313_a == RayTraceResult.Type.BLOCK && (block = (state = mc.field_71441_e.func_180495_p(pos.func_178782_a())).func_177230_c()) == BlockRegistry.RADIANT_TROVE && (te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, (IBlockAccess)mc.field_71441_e, pos.func_178782_a())) != null) {
            ScaledResolution res = event.getResolution();
            int x = res.func_78326_a() / 2 - 40;
            int y = res.func_78328_b() / 2;
            RadiantTroveTileEntity.TroveItemHandler handler = te.getInventory();
            ItemStack item = handler.getItemCurrent();
            if (handler.isLocked()) {
                item = handler.getItem();
            }
            if (!handler.isEmpty() && item.func_77973_b() != Items.field_190931_a) {
                RenderHelper.func_74520_c();
                mc.func_175599_af().func_175042_a(item, x - 40, y);
                RenderHelper.func_74518_a();
                String s = "x " + MathUtils.format(handler.getCount());
                mc.field_71466_p.func_175063_a(item.func_82833_r(), (float)(x - 19 - mc.field_71466_p.func_78256_a(item.func_82833_r()) / 2), (float)(y - 11), 0xFFFFFF);
                mc.field_71466_p.func_175063_a(s, (float)(x - 20), (float)(y + 3), 0xFFFFFF);
                int storage = handler.getTotalUpgradesCount().x;
                int optional = handler.getTotalUpgradesCount().y;
                if (storage + optional != 0) {
                    if (storage + optional == 1) {
                        String n = "" + storage;
                        if (optional > 0) {
                            n = n + "+" + optional;
                        }
                        s = I18n.func_135052_a((String)"arcanearchives.data.gui.radiant_trove.upgrade", (Object[])new Object[]{n});
                    } else {
                        String n = "" + storage;
                        if (optional > 0) {
                            n = n + "+" + optional;
                        }
                        s = I18n.func_135052_a((String)"arcanearchives.data.gui.radiant_trove.upgrades", (Object[])new Object[]{n});
                    }
                    mc.field_71466_p.func_175063_a(TextFormatting.GOLD + s, (float)(x - 19 - mc.field_71466_p.func_78256_a(s) / 2), (float)(y + 20), 0xFFFFFF);
                }
            } else if (handler.getUpgrades() != 0) {
                String s = handler.getUpgrades() == 1 ? I18n.func_135052_a((String)"arcanearchives.data.gui.radiant_trove.upgrade", (Object[])new Object[]{handler.getUpgrades()}) : I18n.func_135052_a((String)"arcanearchives.data.gui.radiant_trove.upgrades", (Object[])new Object[]{handler.getUpgrades()});
                mc.field_71466_p.func_175063_a(TextFormatting.GOLD + s, (float)(x - 19 - mc.field_71466_p.func_78256_a(s) / 2), (float)y, 0xFFFFFF);
            }
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

